/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Objects;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BossCrystal
extends Mob
implements GeoEntity {
    private final NonNullList<ItemStack> storedItems = NonNullList.create();
    private ResourceKey<LootTable> loot_table;
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.defineId(BossCrystal.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final DataTicket<String> TYPE_TICKET = DataTicket.create((String)"crystal_type", String.class);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.bosscrystal.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BossCrystal(EntityType<? extends BossCrystal> pEntityType, Level pLevel, Type t, ResourceKey<LootTable> loot) {
        this(pEntityType, pLevel);
        this.setType(t.getName());
        this.setLootTable(loot);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        LootTable table = Objects.requireNonNull(this.level().getServer()).reloadableRegistries().getLootTable(this.loot_table);
        ObjectArrayList itemList = table.getRandomItems(new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).create(LootContextParamSets.GIFT));
        this.storedItems.addAll((Collection)itemList);
    }

    public BossCrystal(EntityType<? extends BossCrystal> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.FOLLOW_RANGE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.0).build();
    }

    public void aiStep() {
        for (int i = 0; i < 1; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
        super.aiStep();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TYPE, (Object)"type");
    }

    public String getCrystalType() {
        return (String)this.entityData.get(TYPE);
    }

    public void setType(String t) {
        this.entityData.set(TYPE, (Object)t);
    }

    public void setLootTable(ResourceKey<LootTable> table) {
        this.loot_table = table;
    }

    protected void readAdditionalSaveData(ValueInput compound) {
        ContainerHelper.loadAllItems((ValueInput)compound, this.storedItems);
        this.setType(compound.getStringOr("type", "type"));
    }

    protected void addAdditionalSaveData(ValueOutput compound) {
        ContainerHelper.saveAllItems((ValueOutput)compound, this.storedItems, (boolean)true);
        compound.putString("type", this.getCrystalType());
    }

    public boolean canBeCollidedWith(@Nullable Entity e) {
        return true;
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.level().isClientSide()) {
            for (ItemStack storedItem : this.storedItems) {
                ItemStack item = new ItemStack((ItemLike)storedItem.getItem());
                item.setCount(storedItem.getCount());
                ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), item);
                this.level().addFreshEntity((Entity)entity);
            }
            this.playSound((SoundEvent)JSounds.CRYSTAL_PICKUP.get(), 1.0f, 1.0f);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean canCollideWith(Entity e) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public void push(Entity entity) {
    }

    protected void doPush(Entity entityIn) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurtServer(ServerLevel p_376221_, DamageSource p_376460_, float p_376610_) {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public ResourceLocation getTexture() {
        return JITL.rl("textures/entity/crystal/" + this.getCrystalType() + ".png");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> state.setAndContinue(this.IDLE)));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum Type {
        COMMON("common"),
        NETHER("nether"),
        BOIL("boil"),
        EUCA("euca"),
        DEPTHS("depths"),
        CORBA("corba"),
        TERRANIA("terrania"),
        CLOUDIA("cloudia"),
        SENTERIAN("senterian"),
        FROZEN("frozen");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

