/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.core.helper.JMusic;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class TowerGuardian
extends JBossEntity {
    private static final JMusic BOSS_TRACK = new JMusic((SoundEvent)JSounds.TEMPLE_GUARDIAN_MUSIC.get(), 2, 0, 0);
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.tower_guardian.walk");
    private final RawAnimation ATTACK = RawAnimation.begin().thenLoop("animation.tower_guardian.smash");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.tower_guardian.idle");

    public TowerGuardian(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.OVERWORLD, 5);
    }

    @Override
    public boolean showName() {
        return true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new JMonsterEntity.AnimatedAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new IdleHealGoal((Mob)this, 1200));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.ROCK.get();
    }

    public boolean doHurtTarget(ServerLevel level, Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)1);
        float damage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float explosionRadius = 3.0f;
        double particleWidth = 4.0;
        Vec3 vec3 = this.getDeltaMovement();
        float f1 = (int)damage > 0 ? damage / 2.0f + (float)this.random.nextInt((int)damage) : damage;
        boolean hurt = entity.hurtServer(level, this.damageSources().mobAttack((LivingEntity)this), f1);
        int x = Mth.floor((double)entity.getX());
        int y = Mth.floor((double)(entity.getY() - (double)0.2f));
        int z = Mth.floor((double)entity.getZ());
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (hurt) {
            if (this.random.nextInt(15) == 0) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), explosionRadius, Level.ExplosionInteraction.NONE);
            }
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 50; ++i) {
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), this.getX() + (this.random.nextDouble() - 0.5) * particleWidth, this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * particleWidth, vec3.x * -4.0, 1.5, vec3.z * -4.0);
                }
            }
            DamageSource damagesource = this.damageSources().mobAttack((LivingEntity)this);
            Level level2 = this.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity, (DamageSource)damagesource);
            }
        }
        this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        return hurt;
    }

    public void handleEntityEvent(byte id) {
        if (id == 1) {
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        }
        super.handleEntityEvent(id);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 275.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 2.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.1).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isAttacking()) {
                return state.setAndContinue(this.ATTACK);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.COMMON;
    }

    @Override
    public ResourceKey<LootTable> lootTable() {
        return JLootTables.TOWER_GUARDIAN_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return false;
    }
}

