/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.frozen;

import net.jitl.common.entity.base.JAnimalEntity;
import net.jitl.common.entity.goal.ShiveringRamEatBlockGoal;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class ShiveringRam
extends JAnimalEntity
implements Shearable {
    private static final EntityDataAccessor<Boolean> IS_SHEARED = SynchedEntityData.defineId(ShiveringRam.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.defineId(ShiveringRam.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.shivering_ram.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.shivering_ram.idle");
    private final RawAnimation EAT = RawAnimation.begin().thenPlay("animation.shivering_ram.eat");

    public ShiveringRam(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is(JItems.FROST_FLAKE), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new ShiveringRamEatBlockGoal(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.TEMPT_RANGE, 10.0).add(Attributes.MAX_HEALTH, 30.0).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isEating()) {
                return state.setAndContinue(this.EAT);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(JItems.FROST_FLAKE);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_SHEARED, (Object)false);
        builder.define(IS_EATING, (Object)false);
    }

    protected void addAdditionalSaveData(@NotNull ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("sheared", this.isSheared());
        output.putBoolean("eating", this.isEating());
    }

    protected void readAdditionalSaveData(@NotNull ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setSheared(input.getBooleanOr("sheared", false));
        this.setSheared(input.getBooleanOr("eating", false));
    }

    public boolean isEating() {
        return (Boolean)this.entityData.get(IS_EATING);
    }

    public void setEating(boolean eating) {
        this.entityData.set(IS_EATING, (Object)eating);
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(IS_SHEARED, (Object)sheared);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        player.getItemInHand(hand);
        return super.mobInteract(player, hand);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SHEEP_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource d) {
        return SoundEvents.SHEEP_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SHEEP_DEATH;
    }

    protected void playStepSound(BlockPos p, BlockState s) {
        this.playSound(SoundEvents.SHEEP_STEP, 0.15f, 1.0f);
    }

    public void shear(ServerLevel level, SoundSource sounds, ItemStack stack) {
        level.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, sounds, 1.0f, 1.0f);
        this.dropFromShearingLootTable(level, JLootTables.SHIVERING_RAM_WOOL, stack, (server, item) -> {
            for (int i = 0; i < item.getCount(); ++i) {
                ItemEntity itementity = this.spawnAtLocation((ServerLevel)server, item.copyWithCount(1), 1.0f);
                if (itementity == null) continue;
                itementity.setDeltaMovement(itementity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
            }
        });
        this.setSheared(true);
    }

    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    public ShiveringRam getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return (ShiveringRam)((EntityType)JEntities.SHIVERING_RAM_TYPE.get()).create((Level)level, EntitySpawnReason.BREEDING);
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }
}

