/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld.npc;

import java.util.Objects;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.util.ChatUtils;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.common.entity.base.JPathfinderMob;
import net.jitl.common.entity.jmerchant.SentacoinMerchantMenu;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OverworldSentryStalker
extends JPathfinderMob
implements Npc {
    private static final EntityDataAccessor<Boolean> DATA_IS_ACTIVATED = SynchedEntityData.defineId(OverworldSentryStalker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_HAS_KEY = SynchedEntityData.defineId(OverworldSentryStalker.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.neutral_sentry_stalker.idle");
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.neutral_sentry_stalker.walk");

    public OverworldSentryStalker(EntityType<? extends OverworldSentryStalker> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Override
    public void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    public boolean isClientSide() {
        return this.level().isClientSide();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void tick() {
        super.tick();
        if (this.isActivated() && !this.level().isClientSide() && this.hasKey()) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.position().x + 0.5, this.position().y + (double)1.4f, this.position().z + 0.5, new ItemStack((ItemLike)JItems.SENTRY_KEY.get(), 1)));
            this.playSound((SoundEvent)JSounds.COIN_PICKUP.get(), 1.5f, 1.0f);
            this.setHasKey(false);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_IS_ACTIVATED, (Object)false);
        pBuilder.define(DATA_HAS_KEY, (Object)true);
    }

    protected void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("activated", ((Boolean)this.entityData.get(DATA_IS_ACTIVATED)).booleanValue());
        compound.putBoolean("hasKey", ((Boolean)this.entityData.get(DATA_HAS_KEY)).booleanValue());
    }

    protected void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setActivated(compound.getBooleanOr("activated", false));
        this.setHasKey(compound.getBooleanOr("hasKey", false));
    }

    public void setActivated(boolean activated) {
        this.entityData.set(DATA_IS_ACTIVATED, (Object)activated);
    }

    public void setHasKey(boolean activated) {
        this.entityData.set(DATA_HAS_KEY, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.entityData.get(DATA_IS_ACTIVATED);
    }

    public boolean hasKey() {
        return (Boolean)this.entityData.get(DATA_HAS_KEY);
    }

    public boolean hurtServer(ServerLevel p_376221_, DamageSource p_376460_, float p_376610_) {
        return false;
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        PlayerStats stats = (PlayerStats)player.getData(JDataAttachments.PLAYER_STATS);
        if (stats.getLevel(EnumKnowledge.OVERWORLD) >= 75) {
            this.setActivated(true);
        }
        if (this.hasKey()) {
            ChatUtils.addDialogStyleChat(player, "jitl.sen.knowledge_1");
        }
        if (!this.hasKey()) {
            ChatUtils.addDialogStyleChat(player, "jitl.sen.unlocked");
            if (!this.level().isClientSide()) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((menu, inven, title) -> new SentacoinMerchantMenu(menu), Objects.requireNonNull(this.getDisplayName())));
            }
        }
        return super.mobInteract(player, hand);
    }
}

