/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jitl.core.helper.JToolTiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.NotNull;

public class BonemealHoeItem
extends HoeItem {
    public BonemealHoeItem(Item.Properties p, JToolTiers tier, int dam) {
        super(tier.getTier(), (float)dam, tier.getSpeedModifier(), p);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState toolModifiedState = level.getBlockState(blockpos = context.getClickedPos()).getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)BonemealHoeItem.changeIntoState((BlockState)toolModifiedState));
        if (!context.getPlayer().isCrouching()) {
            if (pair == null) {
                return InteractionResult.PASS;
            }
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                Player player = context.getPlayer();
                level.playSound((Entity)player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide()) {
                    consumer.accept(context);
                    if (player != null) {
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, context.getHand());
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            Player player = context.getPlayer();
            if (player instanceof Player) {
                Player player2 = player;
                if (BoneMealItem.applyBonemeal((ItemStack)context.getItemInHand(), (Level)level, (BlockPos)blockpos, (Player)context.getPlayer())) {
                    if (!level.isClientSide()) {
                        context.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                        level.levelEvent(1505, blockpos, 15);
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player2, context.getHand());
                    }
                    return InteractionResult.SUCCESS;
                }
                if (level.getBlockState(blockpos).isFaceSturdy((BlockGetter)level, blockpos, context.getClickedFace()) && BoneMealItem.growWaterPlant((ItemStack)context.getItemInHand(), (Level)level, (BlockPos)blockpos, (Direction)context.getClickedFace())) {
                    if (!level.isClientSide()) {
                        context.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                        level.levelEvent(1505, blockpos, 15);
                        context.getItemInHand().hurtAndBreak(1, (LivingEntity)player2, context.getHand());
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> comp, TooltipFlag pTooltipFlag) {
        comp.accept((Component)Component.translatable((String)"jitl.item.desc.bonemeal_hoe"));
        comp.accept((Component)Component.translatable((String)"jitl.uses_remaining", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}));
    }
}

