/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.jitl.common.items.base.JItem;
import net.jitl.core.init.internal.JLootTables;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class LootItem
extends JItem {
    public LootTier tier;

    public LootItem(Item.Properties props, LootTier tier, Rarity r) {
        super(props.rarity(r).stacksTo(4));
        this.tier = tier;
    }

    @NotNull
    public InteractionResult use(Level world, @NotNull Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        RandomSource rand = world.random;
        ResourceKey<LootTable> loot = JLootTables.LOOT_BASIC;
        switch (this.tier.ordinal()) {
            case 1: {
                loot = JLootTables.LOOT_GOLD;
                break;
            }
            case 2: {
                loot = JLootTables.LOOT_DIAMOND;
                break;
            }
            case 3: {
                loot = JLootTables.LOOT_FROSTY;
            }
        }
        if (!world.isClientSide()) {
            LootTable table = Objects.requireNonNull(world.getServer()).reloadableRegistries().getLootTable(loot);
            ObjectArrayList itemList = table.getRandomItems(new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.ORIGIN, (Object)player.position()).create(LootContextParamSets.GIFT));
            ItemStack spawn = (ItemStack)itemList.get(rand.nextInt(itemList.size()));
            ItemEntity item = new ItemEntity(world, player.position().x, player.position().y, player.position().z, spawn);
            world.addFreshEntity((Entity)item);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public boolean isFoil(ItemStack f) {
        return this.tier == LootTier.DIAMOND;
    }

    public static enum LootTier {
        NORMAL,
        GOLD,
        DIAMOND,
        FROSTY_GIFT;

    }
}

