/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.jitl.common.entity.projectile.MagicPotEntity;
import net.jitl.common.items.base.JItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicPotItem
extends JItem {
    protected BiFunction<Level, LivingEntity, Projectile> projectileFactory = (world, owner) -> new MagicPotEntity((LivingEntity)owner, (Level)world, 3, 4.0f, new ItemStack((ItemLike)this));
    @Nullable
    private Supplier<SoundEvent> sound;

    public MagicPotItem(Item.Properties properties) {
        super(properties);
    }

    public MagicPotItem setSound(Supplier<SoundEvent> sound) {
        this.sound = sound;
        return this;
    }

    public InteractionResult use(Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
        if (this.sound != null) {
            worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), this.sound.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        if (!worldIn.isClientSide()) {
            Projectile projectile = this.projectileFactory.apply(worldIn, (LivingEntity)playerIn);
            projectile.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            worldIn.addFreshEntity((Entity)projectile);
            projectile.setPos(playerIn.getX(), playerIn.getEyeY(), playerIn.getZ());
            if (!playerIn.isCreative()) {
                itemstack.shrink(1);
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return InteractionResult.SUCCESS;
    }
}

