/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.common.entity.base.JBoat;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class JBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final JBoat.Type type;

    public JBoatItem(Item.Properties p, JBoat.Type type) {
        super(p);
        this.type = type;
    }

    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = JBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 vec3 = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResult.PASS;
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            AbstractBoat boat = this.getBoat(level, (HitResult)hitresult, itemstack, player);
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            if (!level.isClientSide()) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)hitresult.getLocation()));
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private AbstractBoat getBoat(Level level, HitResult hitResult, ItemStack stack, Player player) {
        AbstractBoat abstractboat = (AbstractBoat)this.getBoatFromItem().create(level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (abstractboat != null) {
            Vec3 vec3 = hitResult.getLocation();
            abstractboat.setInitialPos(vec3.x, vec3.y, vec3.z);
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EntityType.createDefaultStackConfig((Level)serverlevel, (ItemStack)stack, (LivingEntity)player).accept(abstractboat);
            }
        }
        return abstractboat;
    }

    public EntityType<? extends JBoat> getBoatFromItem() {
        EntityType boat = (EntityType)JEntities.GOLD_EUCA_BOAT_TYPE.get();
        if (this == JItems.GOLDEN_EUCA_BOAT.get()) {
            boat = (EntityType)JEntities.GOLD_EUCA_BOAT_TYPE.get();
        }
        if (this == JItems.BROWN_EUCA_BOAT.get()) {
            boat = (EntityType)JEntities.BROWN_EUCA_BOAT_TYPE.get();
        }
        if (this == JItems.DEPTHS_BOAT.get()) {
            boat = (EntityType)JEntities.DEPTHS_BOAT_TYPE.get();
        }
        if (this == JItems.BURNED_BOAT.get()) {
            boat = (EntityType)JEntities.BURNED_BOAT_TYPE.get();
        }
        if (this == JItems.CORBA_BOAT.get()) {
            boat = (EntityType)JEntities.CORBA_BOAT_TYPE.get();
        }
        if (this == JItems.FROZEN_BOAT.get()) {
            boat = (EntityType)JEntities.FROZEN_BOAT_TYPE.get();
        }
        if (this == JItems.CLOUDIA_BOAT.get()) {
            boat = (EntityType)JEntities.CLOUDIA_BOAT_TYPE.get();
        }
        if (this == JItems.TERRANIAN_BOAT.get()) {
            boat = (EntityType)JEntities.TERRANIA_BOAT_TYPE.get();
        }
        return boat;
    }
}

