/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.entity.projectile.EssenceArrowEntity;
import net.jitl.core.helper.JEnchantmentHelper;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JTags;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class JBowItem
extends BowItem {
    public static final int DEFAULT_DURATION = 72000;
    protected int maxUseDuration;
    protected float damage;
    protected Item arrow_item;
    protected int uses;
    protected int essence_use;
    public EnumSet<EssenceArrowEntity.BowEffects> effect;
    public static final Predicate<ItemStack> ESSENCE_ARROW = tag -> tag.is(JTags.ESSENCE_ARROW);

    public JBowItem(Item.Properties p, float damage, int uses, EnumSet<EssenceArrowEntity.BowEffects> effect, int pullbackSpeed) {
        super(p.stacksTo(1).durability(uses));
        this.effect = effect;
        this.arrow_item = (Item)JItems.ESSENCE_ARROW.get();
        this.damage = damage;
        this.uses = uses;
        this.maxUseDuration = pullbackSpeed;
    }

    public JBowItem setEssenceUse(int amount) {
        this.essence_use = amount;
        return this;
    }

    public float getScaledArrowVelocity(int charge) {
        float timeRatio = 72000.0f / (float)this.maxUseDuration;
        float f = (float)charge / 20.0f * timeRatio;
        if ((f = (f * f + f * 2.0f) / 2.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public boolean releaseUsing(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (worldIn instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)worldIn;
                boolean emptyPickup = player.isCreative() || JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.INFINITY) > 0 || this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE);
                ItemStack itemstack = this.findAmmo(player);
                if (!worldIn.isClientSide()) {
                    int i = this.maxUseDuration - timeLeft;
                    if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)worldIn, (Player)player, (int)i, (!itemstack.isEmpty() || emptyPickup ? 1 : 0) != 0)) < 0) {
                        return emptyPickup;
                    }
                    if (!itemstack.isEmpty() || emptyPickup) {
                        float f;
                        if (itemstack.isEmpty()) {
                            itemstack = new ItemStack((ItemLike)this.arrow_item);
                        }
                        if ((double)(f = this.getScaledArrowVelocity(i)) >= 0.1) {
                            EssenceArrowEntity entityarrow = new EssenceArrowEntity(worldIn, (LivingEntity)player, this.effect, this.damage, stack);
                            EssenceArrowEntity entityarrow2 = new EssenceArrowEntity(worldIn, (LivingEntity)player, this.effect, this.damage, stack);
                            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.DOUBLE_ARROW)) {
                                int k;
                                entityarrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + 3.25f, 0.0f, f * 3.0f, 1.0f);
                                entityarrow2.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 3.25f, 0.0f, f * 3.0f, 1.0f);
                                int j = JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.POWER);
                                if ((float)j == 1.0f) {
                                    entityarrow.setCritArrow(true);
                                    entityarrow2.setCritArrow(true);
                                }
                                if ((k = JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.PUNCH)) > 0) {
                                    // empty if block
                                }
                                if (JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.FLAME) > 0) {
                                    entityarrow.setRemainingFireTicks(2000);
                                    entityarrow2.setRemainingFireTicks(2000);
                                }
                                entityarrow.setBaseDamage(this.damage);
                                entityarrow2.setBaseDamage(this.damage);
                                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                                if (!emptyPickup) {
                                    entityarrow.pickup = AbstractArrow.Pickup.ALLOWED;
                                    entityarrow2.pickup = AbstractArrow.Pickup.ALLOWED;
                                } else {
                                    entityarrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                                    entityarrow2.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                                }
                                worldIn.addFreshEntity((Entity)entityarrow);
                                worldIn.addFreshEntity((Entity)entityarrow2);
                            } else {
                                entityarrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 1.0f);
                                int j = JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.POWER);
                                if ((float)j == 1.0f) {
                                    entityarrow.setCritArrow(true);
                                }
                                int k = JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.PUNCH);
                                if (JEnchantmentHelper.getEnchantmentAmount(player, level, (ResourceKey<Enchantment>)Enchantments.FLAME) > 0) {
                                    entityarrow.setRemainingFireTicks(2000);
                                }
                                entityarrow.setBaseDamage(this.damage);
                                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                                entityarrow.pickup = !emptyPickup ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY;
                                if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE) && ((PlayerEssence)player.getData(JDataAttachments.ESSENCE)).consumeEssence(player, this.essence_use)) {
                                    worldIn.addFreshEntity((Entity)entityarrow);
                                }
                                if (!this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                                    worldIn.addFreshEntity((Entity)entityarrow);
                                }
                            }
                        }
                        worldIn.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                        if (!emptyPickup) {
                            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.DOUBLE_ARROW)) {
                                itemstack.shrink(2);
                            } else {
                                itemstack.shrink(1);
                            }
                        }
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                    }
                }
            }
        }
        return true;
    }

    public ItemStack findAmmo(Player player) {
        if (this.isArrow(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (this.isArrow(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
            return ItemStack.EMPTY;
        }
        for (int i = 0; i < player.inventoryMenu.getItems().size(); ++i) {
            ItemStack itemstack = (ItemStack)player.inventoryMenu.getItems().get(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(stack, pContext, display, tooltip, pTooltipFlag);
        tooltip.accept((Component)Component.translatable((String)("Damage: " + String.valueOf(ChatFormatting.GOLD) + this.damage + " - " + String.valueOf(ChatFormatting.GOLD) + this.damage * 4.0f)));
        float maxUse = 72000.0f / (float)this.maxUseDuration;
        DecimalFormat df = new DecimalFormat("#.##");
        tooltip.accept((Component)Component.translatable((String)("Pull Back Speed: " + String.valueOf(ChatFormatting.GOLD) + df.format(maxUse))));
        if (this.effect != null) {
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.WITHER)) {
                tooltip.accept((Component)Component.translatable((String)(String.valueOf(ChatFormatting.DARK_GRAY) + "Ability: Withers foe")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.FLAME)) {
                tooltip.accept((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GOLD) + "Ability: Sets foe ablaze")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.POISON)) {
                tooltip.accept((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GREEN) + "Ability: Poisons foe")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.SLOWNESS)) {
                tooltip.accept((Component)Component.translatable((String)(String.valueOf(ChatFormatting.BLUE) + "Ability: Stuns foe")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.DOUBLE_ARROW)) {
                tooltip.accept((Component)Component.translatable((String)(String.valueOf(ChatFormatting.BLUE) + "Ability: Shoots 2 arrows")));
            }
            if (this.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                tooltip.accept((Component)Component.translatable((String)(String.valueOf(ChatFormatting.GREEN) + "Ability: Consumes " + this.essence_use + " Essence instead of arrows")));
            }
        }
        tooltip.accept((Component)Component.translatable((String)("Uses remaining: " + String.valueOf(ChatFormatting.GRAY) + this.uses)));
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ESSENCE_ARROW;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_345962_) {
        return this.maxUseDuration;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.getItem() == JItems.ESSENCE_ARROW.get();
    }
}

