/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.scroll;

import java.util.ArrayList;
import java.util.List;
import net.jitl.common.scroll.IDescComponent;
import net.jitl.common.scroll.UnderHeaderDescComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ScrollEntry {
    private final ItemStack displayedItem;
    private final String id;
    private final String titleKey;
    @Nullable
    private final String commentKey;
    private final List<IDescComponent> desc = new ArrayList<IDescComponent>();
    private final int x;
    private final int y;

    public ScrollEntry(String id, String titleKey, @Nullable String commentKey, ItemStack displayedItem, List<IDescComponent> desc, int x, int y) {
        this.displayedItem = displayedItem;
        this.x = x;
        this.y = y;
        this.titleKey = titleKey;
        this.commentKey = commentKey;
        this.desc.add(new UnderHeaderDescComponent());
        this.desc.addAll(desc);
        this.id = id == null ? this.titleKey.toLowerCase().replace(' ', '_') : id;
    }

    public ItemStack getDisplayedItem() {
        return this.displayedItem;
    }

    public String getId() {
        return this.id;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public List<IDescComponent> getDesc() {
        return this.desc;
    }

    public void addDescComponent(IDescComponent descComponent) {
        this.desc.add(descComponent);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    public String getCommentKey() {
        return this.commentKey;
    }

    public boolean hasComment() {
        return this.commentKey != null;
    }
}

