/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.boil;

import com.mojang.serialization.Codec;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SulphurCrystalFeature
extends Feature<NoneFeatureConfiguration> {
    public SulphurCrystalFeature(Codec<NoneFeatureConfiguration> codec_) {
        super(codec_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos1 = context.origin();
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        if (reader.getBlockState(pos1.below()) != ((Block)JBlocks.VOLCANIC_SAND.get()).defaultBlockState()) {
            return false;
        }
        BlockPos pos2 = new BlockPos(pos1.getX(), reader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos1.getX(), pos1.getZ()) - 1, pos1.getZ());
        BlockPos pos = pos2.above(rand.nextInt(4));
        int i = rand.nextInt(20) + 5;
        int j = i / 4 + rand.nextInt(2);
        for (int k = 0; k < i; ++k) {
            float f = (1.0f - (float)k / (float)i) * (float)j;
            int l = Mth.ceil((float)f);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)Mth.abs((int)i1) - 0.5f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)Mth.abs((int)j1) - 0.5f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > f * f || (i1 == -l || i1 == l || j1 == -l || j1 == l) && rand.nextFloat() > 0.75f) continue;
                    BlockState blockstate = reader.getBlockState(pos.offset(i1, k - 12, j1));
                    Block block = blockstate.getBlock();
                    if (!blockstate.isAir() && block != JBlocks.SULPHUR_ROCK.get()) continue;
                    this.setBlock((LevelWriter)reader, pos.offset(i1, k - 12, j1), ((Block)JBlocks.SULPHUR_ROCK.get()).defaultBlockState());
                }
            }
        }
        return true;
    }
}

