/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.boil;

import com.mojang.serialization.Codec;
import net.jitl.common.block.base.AttachedBlock;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class SulphurDepositFeature
extends Feature<BlockStateConfiguration> {
    public SulphurDepositFeature(Codec<BlockStateConfiguration> codec_) {
        super(codec_);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context_) {
        WorldGenLevel reader = context_.level();
        BlockPos pos = context_.origin();
        RandomSource rand = context_.random();
        BlockStateConfiguration config = (BlockStateConfiguration)context_.config();
        if (reader.getBlockState(pos.below()) != ((Block)JBlocks.VOLCANIC_SAND.get()).defaultBlockState()) {
            return false;
        }
        if (pos.getY() > 1 && reader.isEmptyBlock(pos.below())) {
            return false;
        }
        if (pos.getY() <= 1) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        int xPos = pos.getX();
        int zPos = pos.getZ();
        int yPos = reader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, xPos, zPos);
        placePos.set(xPos, yPos - 1, zPos);
        BlockPos blockPos = reader.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos);
        for (int l = 0; l < 2; ++l) {
            placePos.setWithOffset((Vec3i)blockPos, rand.nextInt(20), 0, rand.nextInt(20));
            int i = rand.nextInt(3);
            int j = rand.nextInt(3);
            int k = rand.nextInt(3);
            float f = (float)(i + j + k) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-i, -j, -k), (BlockPos)pos.offset(i, j, k))) {
                if (!(blockpos.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                reader.setBlock(blockpos, config.state, 4);
                for (Direction direction : Direction.values()) {
                    BlockPos blockpos1 = blockPos.relative(direction);
                    if (reader.getBlockState(blockpos1) != Blocks.AIR.defaultBlockState()) continue;
                    BlockState blockstate1 = (BlockState)((Block)JBlocks.SULPHUR_CRYSTAL.get()).defaultBlockState().setValue(AttachedBlock.FACING, (Comparable)direction);
                    if (reader.getBlockState(blockPos) != config.state) continue;
                    reader.setBlock(blockpos1, blockstate1, 2);
                }
            }
            pos = pos.offset(-1 + rand.nextInt(2), -rand.nextInt(2), -1 + rand.nextInt(2));
        }
        return true;
    }
}

