/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.corba;

import com.mojang.serialization.Codec;
import net.jitl.common.block.JBlockFungalShelf;
import net.jitl.core.helper.RandHelper;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

public class CorbaSwampTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public CorbaSwampTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    private boolean isSpawnBlock(BlockState b) {
        return b == ((Block)JBlocks.DRIED_MUD.get()).defaultBlockState() || b == ((Block)JBlocks.TAINTED_MUD.get()).defaultBlockState();
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource random = context.random();
        WorldGenLevel world = context.level();
        BlockPos blockPos = context.origin();
        int treeHeight = 5 + random.nextInt(2) + random.nextInt(2);
        BlockPos soilPos = blockPos.below();
        BlockPos.MutableBlockPos basePos = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY() - 2, blockPos.getZ());
        if (this.isSpawnBlock(world.getBlockState(soilPos))) {
            int i;
            int stumpHeight = random.nextInt(5) + 3;
            for (i = 0; i < stumpHeight; ++i) {
                this.placeStumps(world, basePos);
            }
            for (i = 0; i < treeHeight; ++i) {
                this.placeLog(world, basePos);
            }
            BlockPos.MutableBlockPos leafPos = basePos.move(Direction.DOWN, 2);
            for (int j5 = 0; j5 <= 10; ++j5) {
                for (int l5 = 0; l5 <= 10; ++l5) {
                    this.createCrown(world, leafPos.relative(this.getRandomDirection(random), random.nextInt(2)), random.nextInt(3) + 1);
                    this.createCrown(world, leafPos.relative(this.getRandomDirection(random), random.nextInt(5)), random.nextInt(3) + 1);
                    this.createCrown(world, leafPos.relative(this.getRandomDirection(random), random.nextInt(3)), random.nextInt(3) + 1);
                    this.createCrown(world, leafPos.relative(this.getRandomDirection(random), random.nextInt(5)), random.nextInt(3) + 1);
                }
            }
            for (int i2 = 0; i2 < random.nextInt(5) + 2; ++i2) {
                this.placeStumps(world, basePos);
            }
            int stemChance = random.nextInt(2);
            switch (stemChance) {
                case 0: {
                    int l5;
                    int j5;
                    for (j5 = 0; j5 <= 1; ++j5) {
                        for (l5 = 0; l5 <= 1; ++l5) {
                            this.placeStems(world, leafPos, Direction.EAST);
                        }
                    }
                }
                case 1: {
                    int l5;
                    int j5;
                    for (j5 = 0; j5 <= 1; ++j5) {
                        for (l5 = 0; l5 <= 1; ++l5) {
                            this.placeStems(world, leafPos, Direction.WEST);
                        }
                    }
                    break;
                }
            }
            for (int i3 = 0; i3 < random.nextInt(3); ++i3) {
                this.placeMushroom(world, blockPos.north(2).above(random.nextInt(stumpHeight - 1) + 1), Direction.NORTH);
                this.placeMushroom(world, blockPos.north(1).above(stumpHeight + 1 + random.nextInt(treeHeight - 4)), Direction.NORTH);
                if (stemChance != 1) {
                    this.placeMushroom(world, blockPos.west(2).above(random.nextInt(stumpHeight - 1) + 1), Direction.WEST);
                    this.placeMushroom(world, blockPos.west(1).above(stumpHeight + 1 + random.nextInt(treeHeight - 4)), Direction.WEST);
                }
                if (stemChance != 0) {
                    this.placeMushroom(world, blockPos.east(2).above(random.nextInt(stumpHeight - 1) + 1), Direction.EAST);
                    this.placeMushroom(world, blockPos.east(1).above(stumpHeight + 1 + random.nextInt(treeHeight - 4)), Direction.EAST);
                }
                this.placeMushroom(world, blockPos.south(2).above(random.nextInt(stumpHeight - 1) + 1), Direction.SOUTH);
                this.placeMushroom(world, blockPos.south(1).above(stumpHeight + 1 + random.nextInt(treeHeight - 4)), Direction.SOUTH);
            }
        }
        return true;
    }

    private Direction getRandomDirection(RandomSource random) {
        return RandHelper.chooseEqual(random, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP);
    }

    private void placeLog(WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        this.setBlock((LevelWriter)world, (BlockPos)pos.move(Direction.UP), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).defaultBlockState());
    }

    private void placeStumps(WorldGenLevel world, BlockPos.MutableBlockPos logPos) {
        this.setBlock((LevelWriter)world, logPos.move(Direction.UP).east(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).defaultBlockState());
        this.setBlock((LevelWriter)world, logPos.west(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).defaultBlockState());
        this.setBlock((LevelWriter)world, logPos.north(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).defaultBlockState());
        this.setBlock((LevelWriter)world, logPos.south(), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).defaultBlockState());
    }

    private void placeStems(WorldGenLevel world, BlockPos.MutableBlockPos logPos, Direction direction) {
        this.setBlock((LevelWriter)world, logPos.move(direction, 1).move(Direction.UP, 1).below(5), ((RotatedPillarBlock)JBlocks.BOGWOOD_LOG.get()).defaultBlockState());
    }

    private void createCrown(WorldGenLevel world, BlockPos pos, int size) {
        pos = pos.above();
        for (int x = 0; x <= size; x = (int)((byte)(x + 1))) {
            for (int y = 0; y <= size; y = (int)((byte)(y + 1))) {
                for (int z = 0; z <= size; z = (int)((byte)(z + 1))) {
                    int distance = x >= y & x >= z ? x + (Math.max(y, z) >> 1) + (Math.min(y, z) >> 1) : (y >= x & y >= z ? y + (Math.max(x, z) >> 1) + (Math.min(x, z) >> 1) : z + (Math.max(x, y) >> 1) + (Math.min(x, y) >> 1));
                    if (distance > size) continue;
                    this.placeLeaves(world, pos.offset(-x, y, z));
                    this.placeLeaves(world, pos.offset(-x, y, -z));
                    this.placeLeaves(world, pos.offset(x, y, z));
                    this.placeLeaves(world, pos.offset(x, y, -z));
                }
            }
        }
    }

    private void placeLeaves(WorldGenLevel world, BlockPos pos) {
        this.setBlock((LevelWriter)world, pos, ((Block)JBlocks.BOGWOOD_LEAVES.get()).defaultBlockState());
    }

    private void placeMushroom(WorldGenLevel world, BlockPos pos, Direction facing) {
        this.setBlock((LevelWriter)world, pos, (BlockState)((Block)JBlocks.FUNGAL_SHELF.get()).defaultBlockState().setValue(JBlockFungalShelf.FACING, (Comparable)facing));
    }
}

