/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.euca;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class BoulderFeature
extends Feature<BlockStateConfiguration> {
    public BoulderFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context_) {
        WorldGenLevel reader = context_.level();
        BlockPos pos = context_.origin();
        RandomSource rand = context_.random();
        BlockStateConfiguration config = (BlockStateConfiguration)context_.config();
        if (reader.isEmptyBlock(pos.below())) {
            return false;
        }
        if (pos.getY() > 1 && reader.isEmptyBlock(pos.below())) {
            return false;
        }
        if (pos.getY() <= 1) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        int xPos = pos.getX();
        int zPos = pos.getZ();
        int yPos = reader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, xPos, zPos);
        placePos.set(xPos, yPos - 1, zPos);
        BlockPos blockPos = reader.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos);
        for (int l = 0; l < 2; ++l) {
            placePos.setWithOffset((Vec3i)blockPos, rand.nextInt(20), 0, rand.nextInt(20));
            int size = rand.nextInt(2) + 1;
            float f = (float)(size + size + size) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-size, -size, -size), (BlockPos)pos.offset(size, size, size))) {
                if (!(blockpos.distSqr((Vec3i)pos) <= (double)(f * f))) continue;
                reader.setBlock(blockpos, config.state, 4);
            }
            pos = pos.offset(-1 + rand.nextInt(2), -rand.nextInt(2), -1 + rand.nextInt(2));
        }
        return true;
    }
}

