/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.terrania;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.jitl.common.world.gen.JTreeDecorators;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TerranianLeaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<TerranianLeaveVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(TerranianLeaveVineDecorator::new, dec -> Float.valueOf(dec.probability));
    private final float probability;

    @NotNull
    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)JTreeDecorators.TERRANIAN_DECORATOR.get();
    }

    public TerranianLeaveVineDecorator(float p) {
        this.probability = p;
    }

    public void place(TreeDecorator.Context pContext) {
        RandomSource randomsource = pContext.random();
        pContext.leaves().forEach(d -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos = d.west())) {
                TerranianLeaveVineDecorator.addHangingVine(blockpos, VineBlock.EAST, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos1 = d.east())) {
                TerranianLeaveVineDecorator.addHangingVine(blockpos1, VineBlock.WEST, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos2 = d.north())) {
                TerranianLeaveVineDecorator.addHangingVine(blockpos2, VineBlock.SOUTH, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos3 = d.south())) {
                TerranianLeaveVineDecorator.addHangingVine(blockpos3, VineBlock.NORTH, pContext);
            }
        });
    }

    private static void addHangingVine(BlockPos pPos, BooleanProperty pSideProperty, TreeDecorator.Context pContext) {
        pContext.setBlock(pPos, (BlockState)((Block)JBlocks.TERRANIAN_VINE.get()).defaultBlockState().setValue((Property)pSideProperty, (Comparable)Boolean.TRUE));
        BlockPos blockpos = pPos.below();
        for (int i = 4; pContext.isAir(blockpos) && i > 0; --i) {
            pContext.setBlock(pPos, (BlockState)((Block)JBlocks.TERRANIAN_VINE.get()).defaultBlockState().setValue((Property)pSideProperty, (Comparable)Boolean.TRUE));
            blockpos = blockpos.below();
        }
    }
}

