/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jitl.core.init.JITL;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class JDamageSources {
    public static final ResourceKey<DamageType> BRADBERRY_BUSH = JDamageSources.register("bradberry_bush");
    public static final ResourceKey<DamageType> REDCURRANT_BUSH = JDamageSources.register("redcurrant_bush");
    public static final ResourceKey<DamageType> DEMONIC_BOMB = JDamageSources.register("demonic_bomb");
    public static final ResourceKey<DamageType> FIRE_BOMB = JDamageSources.register("fire_bomb");

    public static void register(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, packOutput -> new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, bootstrap -> bootstrap.register(BRADBERRY_BUSH, (Object)JDamageSources.addDamageType(BRADBERRY_BUSH))), Set.of("jitl")));
    }

    private static DamageType addDamageType(ResourceKey<DamageType> damage) {
        return new DamageType(String.valueOf(damage.location()) + ".damage", DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.HURT, DeathMessageType.DEFAULT);
    }

    private static ResourceKey<DamageType> register(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)JITL.rl(name));
    }

    public static DamageSource hurt(Entity causer, ResourceKey<DamageType> damage) {
        return new DamageSource((Holder)causer.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(damage), causer);
    }
}

