/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data;

import java.util.Objects;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class JRecipeProvider
extends RecipeProvider {
    private final HolderGetter<Item> items;
    protected final RecipeOutput output;

    public JRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
        this.items = provider.lookupOrThrow(Registries.ITEM);
        this.output = recipeOutput;
    }

    protected void buildRecipes() {
        this.buildBlockRecipes(this.output);
        this.buildItemRecipes(this.output);
        this.buildWoodTypes(this.output);
        this.buildDecorTypes(this.output);
        this.buildQuartzTypes(this.output);
        this.buildSmithingRecipes(this.output);
    }

    public void buildBlockRecipes(RecipeOutput recipeConsumer) {
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.GREEN_GEM.get(), (ItemLike)JBlocks.GREEN_GEM_BLOCK.get());
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.PURPLE_GEM.get(), (ItemLike)JBlocks.PURPLE_GEM_BLOCK.get());
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.BLUE_GEM.get(), (ItemLike)JBlocks.BLUE_GEM_BLOCK.get());
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.YELLOW_GEM.get(), (ItemLike)JBlocks.YELLOW_GEM_BLOCK.get());
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.GREEN_GEM_BLOCK.get(), (ItemLike)JItems.GREEN_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.PURPLE_GEM_BLOCK.get(), (ItemLike)JItems.PURPLE_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.BLUE_GEM_BLOCK.get(), (ItemLike)JItems.BLUE_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.YELLOW_GEM_BLOCK.get(), (ItemLike)JItems.YELLOW_GEM.get(), 9);
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.IRIDIUM_NUGGET.get(), (ItemLike)JBlocks.IRIDIUM_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.IRIDIUM_ORE.get(), (ItemLike)JItems.IRIDIUM_NUGGET.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.ENDERILLIUM_SHARD.get(), (ItemLike)JBlocks.ENDERILLIUM_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.ENDERILLIUM_ORE.get(), (ItemLike)JItems.ENDERILLIUM_SHARD.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.ASH.get(), (ItemLike)JBlocks.ASHUAL_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.ASHUAL_ORE.get(), (ItemLike)JItems.ASH.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.PERIDOT_GEMSTONE.get(), (ItemLike)JBlocks.PERIDOT_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.PERIDOT_ORE.get(), (ItemLike)JItems.PERIDOT_GEMSTONE.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.RIMESTONE.get(), (ItemLike)JBlocks.RIMESTONE_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.RIMESTONE_ORE.get(), (ItemLike)JItems.RIMESTONE.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.BLAZIUM_INGOT.get(), (ItemLike)JBlocks.BLAZIUM_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JItems.RAW_BLAZIUM.get(), (ItemLike)JItems.BLAZIUM_INGOT.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.FIRESTONE_ORE.get(), (ItemLike)JItems.FIRESTONE_CLUMP.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.FIRESTONE_CLUMP.get(), (ItemLike)JBlocks.FIRESTONE_BLOCK.get());
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.SHADIUM, (ItemLike)JBlocks.SHADIUM_BLOCK.get(), (ItemLike)JBlocks.SHADIUM_ORE.get(), (ItemLike)JBlocks.DEEPSLATE_SHADIUM_ORE.get(), (ItemLike)JItems.RAW_SHADIUM.get(), (ItemLike)JItems.SHADIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.SAPPHIRE, (ItemLike)JBlocks.SAPPHIRE_BLOCK.get(), (ItemLike)JBlocks.SAPPHIRE_ORE.get(), (ItemLike)JBlocks.DEEPSLATE_SAPPHIRE_ORE.get(), null, (ItemLike)JItems.SAPPHIRE.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.LUNIUM, (ItemLike)JBlocks.LUNIUM_BLOCK.get(), (ItemLike)JBlocks.LUNIUM_ORE.get(), (ItemLike)JBlocks.DEEPSLATE_LUNIUM_ORE.get(), (ItemLike)JItems.LUNIUM_POWDER.get(), (ItemLike)JItems.LUNIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.BLOODCRUST, (ItemLike)JBlocks.BLOODCRUST_BLOCK.get(), (ItemLike)JBlocks.BLOODCRUST_ORE.get(), null, (ItemLike)JItems.RAW_BLOODCRUST.get(), (ItemLike)JItems.BLOODCRUST_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.CELESTIUM, (ItemLike)JBlocks.CELESTIUM_BLOCK.get(), (ItemLike)JBlocks.CELESTIUM_ORE.get(), null, (ItemLike)JItems.CELESTIUM_GEMSTONE.get(), (ItemLike)JItems.CELESTIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, RecipePrefix.KORITE, (ItemLike)JBlocks.KORITE_BLOCK.get(), (ItemLike)JBlocks.KORITE_ORE.get(), null, (ItemLike)JItems.KORITE_GEMSTONE.get(), (ItemLike)JItems.KORITE_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, RecipePrefix.STORON, (ItemLike)JBlocks.STORON_BLOCK.get(), (ItemLike)JBlocks.STORON_ORE.get(), null, (ItemLike)JItems.STORON_GEMSTONE.get(), (ItemLike)JItems.STORON_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, RecipePrefix.MEKYUM, (ItemLike)JBlocks.MEKYUM_BLOCK.get(), (ItemLike)JBlocks.MEKYUM_ORE.get(), null, (ItemLike)JItems.MEKYUM_GEMSTONE.get(), (ItemLike)JItems.MEKYUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.FLAIRIUM, (ItemLike)JBlocks.FLAIRIUM_BLOCK.get(), (ItemLike)JBlocks.FLAIRIUM_ORE.get(), null, null, (ItemLike)JItems.FLAIRIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, RecipePrefix.DES, (ItemLike)JBlocks.DES_BLOCK.get(), (ItemLike)JBlocks.DES_ORE.get(), null, null, (ItemLike)JItems.DES_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, RecipePrefix.GORBITE, (ItemLike)JBlocks.GORBITE_BLOCK.get(), (ItemLike)JBlocks.GORBITE_ORE.get(), null, null, (ItemLike)JItems.GORBITE_GEM.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, RecipePrefix.ORBADITE, (ItemLike)JBlocks.ORBADITE_BLOCK.get(), (ItemLike)JBlocks.ORBADITE_ORE.get(), null, (ItemLike)JItems.RAW_ORBADITE.get(), (ItemLike)JItems.ORBADITE_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, RecipePrefix.SOULSTONE, (ItemLike)JBlocks.SOULSTONE_BLOCK.get(), null, null, null, (ItemLike)JItems.SOULSTONE.get(), (ItemLike)JItems.OBSIDIAN_STICK.get());
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dsd", "iii", 'i', (ItemLike)JBlocks.BLOOD_ROCK.get(), 'd', (ItemLike)JItems.BLOODCRUST_INGOT.get(), 's', (ItemLike)JItems.BLEEDSTONE.get(), (ItemLike)JBlocks.SUMMONING_TABLE.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dd", "dd", 'd', (ItemLike)JBlocks.BLOOD_ROCK.get(), (ItemLike)JBlocks.BLOOD_BRICKS.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dd", "dd", 'd', (ItemLike)JBlocks.BLOOD_BRICKS.get(), (ItemLike)JBlocks.CARVED_BLOOD_ROCK.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "ddd", "did", "ddd", 'i', (ItemLike)Blocks.GLOWSTONE, 'd', (ItemLike)JBlocks.BLOOD_ROCK.get(), (ItemLike)JBlocks.BLOOD_LAMP.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "ddd", "did", "ddd", 'i', (ItemLike)JBlocks.BLOOD_ROCK.get(), 'd', (ItemLike)JItems.BOIL_POWDER.get(), (ItemLike)JBlocks.OBELISK.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "ddd", "did", "ddd", 'd', (ItemLike)JBlocks.BLOOD_ROCK.get(), 'i', (ItemLike)JItems.BALMY_TEARDROP.get(), (ItemLike)JBlocks.BLOOD_RUNE.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dd", "dd", 'd', (ItemLike)JBlocks.CARVED_BLOOD_ROCK.get(), (ItemLike)JBlocks.BLOOD_PILLAR.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "d", "d", 'd', (ItemLike)Blocks.OBSIDIAN, (ItemLike)JItems.OBSIDIAN_STICK.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, " i ", "igi", " i ", 'i', (ItemLike)JItems.IRIDIUM_NUGGET, 'g', (ItemLike)Blocks.GLOWSTONE, (ItemLike)JBlocks.IRIDIUM_LAMP.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.DECORATIONS, "i", "s", 'i', (ItemLike)JItems.IRIDIUM_NUGGET, 's', (ItemLike)Items.STICK, (ItemLike)JItems.IRIDIUM_TORCH.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, " s ", "sis", "ppp", 'i', (ItemLike)JItems.IRIDIUM_NUGGET, 's', (ItemLike)Items.STICK, 'p', (TagKey<Item>)ItemTags.PLANKS, (ItemLike)JBlocks.IRIDIUM_CAMPFIRE.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, " s ", "scs", "ppp", 'c', (ItemLike)Items.COAL, 's', (ItemLike)Items.STICK, 'p', (ItemLike)JBlocks.FROZEN_PLANKS, (ItemLike)JBlocks.BITTERWOOD_CAMPFIRE.get(), 1);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.EUCA_PORTAL_GEM.get(), (ItemLike)JBlocks.EUCA_PORTAL_FRAME.get(), 10);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.DEPTHS_PORTAL_GEM.get(), (ItemLike)JBlocks.DEPTHS_PORTAL_FRAME.get(), 12);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.CORBA_PORTAL_GEM.get(), (ItemLike)JBlocks.CORBA_PORTAL_FRAME.get(), 12);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.TERRANIA_PORTAL_GEM.get(), (ItemLike)JBlocks.TERRANIAN_PORTAL_FRAME.get(), 10);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.CLOUDIA_PORTAL_GEM.get(), (ItemLike)JBlocks.CLOUDIA_PORTAL_FRAME.get(), 10);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "iii", "idi", "iii", 'i', (ItemLike)Items.SNOWBALL, 'd', (ItemLike)Items.DIAMOND, (ItemLike)JBlocks.FROZEN_PORTAL_FRAME.get(), 10);
        this.add2x2Recipe(recipeConsumer, (ItemLike)JItems.SMITHSTONE.get(), (ItemLike)JBlocks.SMITHSTONE_BLOCK.get(), true);
        this.add2x2Recipe(recipeConsumer, (ItemLike)JItems.BLEEDSTONE.get(), (ItemLike)JBlocks.BLEEDSTONE_BLOCK.get(), true);
    }

    public void buildItemRecipes(RecipeOutput recipeConsumer) {
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "iii", "idi", "iii", 'i', (ItemLike)Items.GOLD_INGOT, 'd', (ItemLike)Items.DIAMOND, (ItemLike)JItems.FLAME_COIN.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.STONE_CLUMP.get(), 'i', (ItemLike)Blocks.STONE, (ItemLike)JItems.REINFORCED_STONE_INGOT.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.STONE_CLUMP.get(), 'i', (ItemLike)JItems.CAVE_CRYSTAL.get(), (ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "iei", "iii", 'i', (ItemLike)JItems.MAGIC_DUST.get(), 'e', (ItemLike)Items.ENDER_PEARL, (ItemLike)JItems.CRYSTAL_BALL.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "ddd", "did", "ddd", 'd', (ItemLike)JItems.DEMONIC_DUST.get(), 'i', (ItemLike)JItems.CRYSTAL_BALL.get(), (ItemLike)JItems.DEMONIC_BOMB.get(), 16);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "ddd", "did", "ddd", 'd', (ItemLike)JItems.MAGIC_DUST.get(), 'i', (ItemLike)JItems.CRYSTAL_BALL.get(), (ItemLike)JItems.MAGIC_BOMB.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "ddd", "ddd", 'd', (ItemLike)JItems.CAVE_DUST.get(), (ItemLike)JItems.STONE_CLUMP.get(), 4, "_2");
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "ddd", "ddd", 'd', (ItemLike)Blocks.STONE, (ItemLike)JItems.STONE_CLUMP.get(), 16);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.WITHIC_DUST.get(), 'i', (ItemLike)JItems.LOST_SOUL.get(), (ItemLike)JItems.WITHIC_SOUL.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.BLOOD.get(), 'i', (ItemLike)JItems.LOST_SOUL.get(), (ItemLike)JItems.CONCENTRATED_BLOOD.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "dgd", "did", "dgd", 'd', (ItemLike)JItems.FLAMING_SPRING.get(), 'i', (ItemLike)JItems.FLAMING_SPROCKET.get(), 'g', (ItemLike)Items.GOLD_INGOT, (ItemLike)JItems.NETHER_KEY.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.DEMONIC_BONE.get(), (ItemLike)JItems.DEMONIC_DUST.get(), 5);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.SMITHSTONE.get(), (ItemLike)JItems.SMITHSTONE_DUST.get(), 4);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.BLEEDSTONE.get(), (ItemLike)JItems.BLEEDSTONE_DUST.get(), 4);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.BLEEDSTONE_DUST.get(), (ItemLike)JItems.SMITHSTONE_DUST.get(), (ItemLike)JItems.SOULSTONE.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.SHADIUM_INGOT.get(), (ItemLike)Items.DIAMOND, (ItemLike)JItems.DARK_GEM.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", 'd', (ItemLike)JItems.BLOODCRUST_INGOT.get(), (ItemLike)JItems.BLOODCRUST_CLUMP.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", 'd', (ItemLike)JItems.SHADIUM_INGOT.get(), (ItemLike)JItems.SHADIUM_CLUMP.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", 'd', (ItemLike)JItems.LUNIUM_INGOT.get(), (ItemLike)JItems.LUNIUM_CLUMP.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.BLOODCRUST_CLUMP.get(), (ItemLike)JItems.SHADIUM_CLUMP.get(), (ItemLike)JItems.LUNIUM_CLUMP.get(), (ItemLike)JItems.SPAWNER_CLUMP.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.EUCA_PORTAL_PIECE_1.get(), (ItemLike)JItems.EUCA_PORTAL_PIECE_2.get(), (ItemLike)JItems.EUCA_PORTAL_PIECE_3.get(), (ItemLike)JItems.EUCA_PORTAL_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE, (ItemLike)JItems.DEMONIC_DUST.get(), (ItemLike)JItems.DEMONIC_EYE.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE, (ItemLike)JItems.SENTRY_STONE.get(), (ItemLike)JItems.SENTRY_EYE.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.FLAME_COIN.get(), (ItemLike)Items.BOOK, (ItemLike)JItems.RECIPE_BOOK.get(), 1);
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.BLOODCRUST_INGOT.get(), (ItemLike)JItems.WITHIC_DUST.get(), (ItemLike)JItems.WITHIC_BLADE.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.STONE_STICK.get(), (ItemLike)JItems.REINFORCED_STONE_INGOT.get(), (ItemLike)JItems.REINFORCED_STONE_SWORD.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.STONE_STICK.get(), (ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), (ItemLike)JItems.REINFORCED_CRYSTAL_SWORD.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.STONE_CLUMP.get(), (ItemLike)JItems.FLORO_PEDAL.get(), (ItemLike)JItems.PEDAL_SWORD.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)Blocks.STONE, (ItemLike)JItems.CAVE_CRYSTAL.get(), (ItemLike)JItems.CRYSTAL_BLADE.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.DEMONIC_BONE.get(), (ItemLike)JItems.DEMONIC_DUST.get(), (ItemLike)JItems.DEMONIC_SWORD.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JItems.SPAWNER_CLUMP.get(), (ItemLike)JItems.SPAWNER_BAR.get());
        this.threeByThreePacker(RecipeCategory.BUILDING_BLOCKS, (ItemLike)JBlocks.AIRROOT_MELON.get(), (ItemLike)JItems.AIRMELON.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)Items.ROTTEN_FLESH, (ItemLike)Items.LEATHER);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "pep", "eye", "pep", 'e', (ItemLike)JItems.ENDERILLIUM_SHARD, 'p', (ItemLike)Items.ENDER_PEARL, 'y', (ItemLike)Items.ENDER_EYE, (ItemLike)JItems.MINERS_PEARL.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "pep", "eye", "pep", 'e', (ItemLike)JItems.DARK_ORB, 'p', (ItemLike)JItems.LIGHT_TERRANIAN_SOIL, 'y', (ItemLike)JItems.MAGIC_DUST, (ItemLike)JItems.MOON_OF_ETERNAL_NIGHT.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, " w ", "www", " w ", 'w', (ItemLike)Items.WHEAT, (ItemLike)JItems.PET_FOOD, 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "  e", " s ", "s  ", 's', (ItemLike)JItems.STONE_STICK.get(), 'e', (ItemLike)Items.ENDER_PEARL, (ItemLike)JItems.STAFF_BASE.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "s", "s", 's', (ItemLike)Blocks.STONE, (ItemLike)JItems.STONE_STICK.get(), 2);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, " ii", "igi", "ib ", 'i', (ItemLike)Items.IRON_INGOT, 'g', (ItemLike)Items.GUNPOWDER, 'b', (TagKey<Item>)ItemTags.BUTTONS, (ItemLike)JItems.GUN_BASE.get(), 1);
    }

    public void buildWoodTypes(RecipeOutput consumer) {
        this.addWoodType(consumer, JBlocks.EUCA_GOLD_LOG, JBlocks.EUCA_GOLD_PLANKS, JBlocks.EUCA_GOLD_STAIRS, JBlocks.EUCA_GOLD_SLAB, JBlocks.EUCA_GOLD_FENCE, JBlocks.EUCA_GOLD_FENCE_GATE, JBlocks.EUCA_GOLD_TRAP_DOOR, JBlocks.EUCA_GOLD_PRESSURE_PLATE, JBlocks.EUCA_GOLD_DOOR, JBlocks.EUCA_GOLD_BUTTON, JItems.GOLDEN_EUCA_BOAT);
        this.addWoodType(consumer, JBlocks.EUCA_BROWN_LOG, JBlocks.EUCA_BROWN_PLANKS, JBlocks.EUCA_BROWN_STAIRS, JBlocks.EUCA_BROWN_SLAB, JBlocks.EUCA_BROWN_FENCE, JBlocks.EUCA_BROWN_FENCE_GATE, JBlocks.EUCA_BROWN_TRAP_DOOR, JBlocks.EUCA_BROWN_PRESSURE_PLATE, JBlocks.EUCA_BROWN_DOOR, JBlocks.EUCA_BROWN_BUTTON, JItems.BROWN_EUCA_BOAT);
        this.addWoodType(consumer, JBlocks.FROZEN_LOG, JBlocks.FROZEN_PLANKS, JBlocks.FROZEN_STAIRS, JBlocks.FROZEN_SLAB, JBlocks.FROZEN_FENCE, JBlocks.FROZEN_FENCE_GATE, JBlocks.FROZEN_TRAP_DOOR, JBlocks.FROZEN_PRESSURE_PLATE, JBlocks.FROZEN_DOOR, JBlocks.FROZEN_BUTTON, JItems.FROZEN_BOAT);
        this.addWoodType(consumer, JBlocks.BURNED_BARK, JBlocks.BURNED_PLANKS, JBlocks.BURNED_STAIRS, JBlocks.BURNED_SLAB, JBlocks.BURNED_FENCE, JBlocks.BURNED_FENCE_GATE, JBlocks.BURNED_TRAP_DOOR, JBlocks.BURNED_PRESSURE_PLATE, JBlocks.BURNED_DOOR, JBlocks.BURNED_BUTTON, JItems.BURNED_BOAT);
        this.addWoodType(consumer, JBlocks.DEPTHS_LOG, JBlocks.DEPTHS_PLANKS, JBlocks.DEPTHS_STAIRS, JBlocks.DEPTHS_SLAB, JBlocks.DEPTHS_FENCE, JBlocks.DEPTHS_FENCE_GATE, JBlocks.DEPTHS_TRAP_DOOR, JBlocks.DEPTHS_PRESSURE_PLATE, JBlocks.DEPTHS_DOOR, JBlocks.DEPTHS_BUTTON, JItems.DEPTHS_BOAT);
        this.addWoodType(consumer, JBlocks.CORBA_LOG, JBlocks.CORBA_PLANKS, JBlocks.CORBA_STAIRS, JBlocks.CORBA_SLAB, JBlocks.CORBA_FENCE, JBlocks.CORBA_FENCE_GATE, JBlocks.CORBA_TRAP_DOOR, JBlocks.CORBA_PRESSURE_PLATE, JBlocks.CORBA_DOOR, JBlocks.CORBA_BUTTON, JItems.CORBA_BOAT);
        this.addWoodType(consumer, JBlocks.TERRANIAN_LOG, JBlocks.TERRANIAN_PLANKS, JBlocks.TERRANIAN_STAIRS, JBlocks.TERRANIAN_SLAB, JBlocks.TERRANIAN_POST, JBlocks.TERRANIAN_FENCE_GATE, JBlocks.TERRANIAN_TRAP_DOOR, JBlocks.TERRANIAN_PRESSURE_PLATE, JBlocks.TERRANIAN_DOOR, JBlocks.TERRANIAN_BUTTON, JItems.TERRANIAN_BOAT);
        this.addWoodType(consumer, JBlocks.CLOUDIA_LOG, JBlocks.CLOUDIA_PLANKS, JBlocks.CLOUDIA_STAIRS, JBlocks.CLOUDIA_SLAB, JBlocks.CLOUDIA_FENCE, JBlocks.CLOUDIA_FENCE_GATE, JBlocks.CLOUDIA_TRAP_DOOR, JBlocks.CLOUDIA_PRESSURE_PLATE, JBlocks.CLOUDIA_DOOR, JBlocks.CLOUDIA_BUTTON, JItems.CLOUDIA_BOAT);
    }

    public void buildDecorTypes(RecipeOutput consumer) {
        this.addDecorType(consumer, JBlocks.BOIL_COBBLESTONE, JBlocks.BOIL_COBBLESTONE_STAIRS, JBlocks.BOIL_COBBLESTONE_WALL, JBlocks.BOIL_COBBLESTONE_SLAB, JBlocks.BOIL_COBBLESTONE_FENCE, JBlocks.BOIL_COBBLESTONE_FENCE_GATE, JBlocks.BOIL_COBBLESTONE_PRESSURE_PLATE, JBlocks.BOIL_COBBLESTONE_BUTTON);
        this.addDecorType(consumer, JBlocks.BOIL_BRICKS, JBlocks.BOIL_BRICK_STAIRS, JBlocks.BOIL_BRICK_WALL, JBlocks.BOIL_BRICK_SLAB, JBlocks.BOIL_BRICK_FENCE, JBlocks.BOIL_BRICK_FENCE_GATE, JBlocks.BOIL_BRICK_PRESSURE_PLATE, JBlocks.BOIL_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.BOIL_SQUARE_BRICKS, JBlocks.BOIL_SQUARE_BRICK_STAIRS, JBlocks.BOIL_SQUARE_BRICK_WALL, JBlocks.BOIL_SQUARE_BRICK_SLAB, JBlocks.BOIL_SQUARE_BRICK_FENCE, JBlocks.BOIL_SQUARE_BRICK_FENCE_GATE, JBlocks.BOIL_SQUARE_BRICK_PRESSURE_PLATE, JBlocks.BOIL_SQUARE_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.BOIL_SHINGLE, JBlocks.BOIL_SHINGLE_STAIRS, JBlocks.BOIL_SHINGLE_WALL, JBlocks.BOIL_SHINGLE_SLAB, JBlocks.BOIL_SHINGLE_FENCE, JBlocks.BOIL_SHINGLE_FENCE_GATE, JBlocks.BOIL_SHINGLE_PRESSURE_PLATE, JBlocks.BOIL_SHINGLE_BUTTON);
        this.addDecorType(consumer, JBlocks.BLAZIER_BRICKS, JBlocks.BLAZIER_BRICK_STAIRS, JBlocks.BLAZIER_BRICK_WALL, JBlocks.BLAZIER_BRICK_SLAB, JBlocks.BLAZIER_BRICK_FENCE, JBlocks.BLAZIER_BRICK_FENCE_GATE, JBlocks.BLAZIER_BRICK_PRESSURE_PLATE, JBlocks.BLAZIER_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.BLAZIER_METAL, JBlocks.BLAZIER_METAL_STAIRS, JBlocks.BLAZIER_METAL_WALL, JBlocks.BLAZIER_METAL_SLAB, JBlocks.BLAZIER_METAL_FENCE, JBlocks.BLAZIER_METAL_FENCE_GATE, JBlocks.BLAZIER_METAL_PRESSURE_PLATE, JBlocks.BLAZIER_METAL_BUTTON);
        this.addDecorType(consumer, JBlocks.GOLDITE_COBBLESTONE, JBlocks.GOLDITE_COBBLESTONE_STAIRS, JBlocks.GOLDITE_COBBLESTONE_WALL, JBlocks.GOLDITE_COBBLESTONE_SLAB, JBlocks.GOLDITE_COBBLESTONE_FENCE, JBlocks.GOLDITE_COBBLESTONE_FENCE_GATE, JBlocks.GOLDITE_COBBLESTONE_PRESSURE_PLATE, JBlocks.GOLDITE_COBBLESTONE_BUTTON);
        this.addDecorType(consumer, JBlocks.PERMAFROST, JBlocks.PERMAFROST_STAIRS, JBlocks.PERMAFROST_WALL, JBlocks.PERMAFROST_SLAB, JBlocks.PERMAFROST_FENCE, JBlocks.PERMAFROST_FENCE_GATE, JBlocks.PERMAFROST_PRESSURE_PLATE, JBlocks.PERMAFROST_BUTTON);
        this.addDecorType(consumer, JBlocks.PACKED_SNOW_BRICKS, JBlocks.PACKED_SNOW_BRICK_STAIRS, JBlocks.PACKED_SNOW_BRICK_WALL, JBlocks.PACKED_SNOW_BRICK_SLAB, JBlocks.PACKED_SNOW_BRICK_FENCE, JBlocks.PACKED_SNOW_BRICK_FENCE_GATE, JBlocks.PACKED_SNOW_BRICK_PRESSURE_PLATE, JBlocks.PACKED_SNOW_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.PACKED_ICE_BRICKS, JBlocks.PACKED_ICE_BRICK_STAIRS, JBlocks.PACKED_ICE_BRICK_WALL, JBlocks.PACKED_ICE_BRICK_SLAB, JBlocks.PACKED_ICE_BRICK_FENCE, JBlocks.PACKED_ICE_BRICK_FENCE_GATE, JBlocks.PACKED_ICE_BRICK_PRESSURE_PLATE, JBlocks.PACKED_ICE_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.FROZEN_BRICKS, JBlocks.FROZEN_BRICK_STAIRS, JBlocks.FROZEN_BRICK_WALL, JBlocks.FROZEN_BRICK_SLAB, JBlocks.FROZEN_BRICK_FENCE, JBlocks.FROZEN_BRICK_FENCE_GATE, JBlocks.FROZEN_BRICK_PRESSURE_PLATE, JBlocks.FROZEN_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.VOLCANIC_SANDSTONE, JBlocks.VOLCANIC_SANDSTONE_STAIRS, JBlocks.VOLCANIC_SANDSTONE_WALL, JBlocks.VOLCANIC_SANDSTONE_SLAB, JBlocks.VOLCANIC_SANDSTONE_FENCE, JBlocks.VOLCANIC_SANDSTONE_FENCE_GATE, JBlocks.VOLCANIC_SANDSTONE_PRESSURE_PLATE, JBlocks.VOLCANIC_SANDSTONE_BUTTON);
        this.addDecorType(consumer, JBlocks.DARK_BRICK, JBlocks.DARK_BRICK_STAIRS, JBlocks.DARK_BRICK_WALL, JBlocks.DARK_BRICK_SLAB, JBlocks.DARK_BRICK_FENCE, JBlocks.DARK_BRICK_FENCE_GATE, JBlocks.DARK_BRICK_PRESSURE_PLATE, JBlocks.DARK_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.DARK_FLOOR, JBlocks.DARK_FLOOR_STAIRS, JBlocks.DARK_FLOOR_WALL, JBlocks.DARK_FLOOR_SLAB, JBlocks.DARK_FLOOR_FENCE, JBlocks.DARK_FLOOR_FENCE_GATE, JBlocks.DARK_FLOOR_PRESSURE_PLATE, JBlocks.DARK_FLOOR_BUTTON);
        this.addDecorType(consumer, JBlocks.DARK_SHINGLE, JBlocks.DARK_SHINGLE_STAIRS, JBlocks.DARK_SHINGLE_WALL, JBlocks.DARK_SHINGLE_SLAB, JBlocks.DARK_SHINGLE_FENCE, JBlocks.DARK_SHINGLE_FENCE_GATE, JBlocks.DARK_SHINGLE_PRESSURE_PLATE, JBlocks.DARK_SHINGLE_BUTTON);
        this.addDecorType(consumer, JBlocks.DEPTHS_BRICK, JBlocks.DEPTHS_BRICK_STAIRS, JBlocks.DEPTHS_BRICK_WALL, JBlocks.DEPTHS_BRICK_SLAB, JBlocks.DEPTHS_BRICK_FENCE, JBlocks.DEPTHS_BRICK_FENCE_GATE, JBlocks.DEPTHS_BRICK_PRESSURE_PLATE, JBlocks.DEPTHS_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.DEPTHS_SHINGLE, JBlocks.DEPTHS_SHINGLE_STAIRS, JBlocks.DEPTHS_SHINGLE_WALL, JBlocks.DEPTHS_SHINGLE_SLAB, JBlocks.DEPTHS_SHINGLE_FENCE, JBlocks.DEPTHS_SHINGLE_FENCE_GATE, JBlocks.DEPTHS_SHINGLE_PRESSURE_PLATE, JBlocks.DEPTHS_SHINGLE_BUTTON);
        this.addDecorType(consumer, JBlocks.DEPTHS_DARK_SHINGLE, JBlocks.DEPTHS_DARK_SHINGLE_STAIRS, JBlocks.DEPTHS_DARK_SHINGLE_WALL, JBlocks.DEPTHS_DARK_SHINGLE_SLAB, JBlocks.DEPTHS_DARK_SHINGLE_FENCE, JBlocks.DEPTHS_DARK_SHINGLE_FENCE_GATE, JBlocks.DEPTHS_DARK_SHINGLE_PRESSURE_PLATE, JBlocks.DEPTHS_DARK_SHINGLE_BUTTON);
        this.addDecorType(consumer, JBlocks.DEPTHS_COBBLESTONE, JBlocks.DEPTHS_COBBLESTONE_STAIRS, JBlocks.DEPTHS_COBBLESTONE_WALL, JBlocks.DEPTHS_COBBLESTONE_SLAB, JBlocks.DEPTHS_COBBLESTONE_FENCE, JBlocks.DEPTHS_COBBLESTONE_FENCE_GATE, JBlocks.DEPTHS_COBBLESTONE_PRESSURE_PLATE, JBlocks.DEPTHS_COBBLESTONE_BUTTON);
        this.addDecorType(consumer, JBlocks.DEPTHS_TILE, JBlocks.DEPTHS_TILE_STAIRS, JBlocks.DEPTHS_TILE_WALL, JBlocks.DEPTHS_TILE_SLAB, JBlocks.DEPTHS_TILE_FENCE, JBlocks.DEPTHS_TILE_FENCE_GATE, JBlocks.DEPTHS_TILE_PRESSURE_PLATE, JBlocks.DEPTHS_TILE_BUTTON);
        this.addDecorType(consumer, JBlocks.CORBA_DARK_BRICKS, JBlocks.CORBA_DARK_BRICK_STAIRS, JBlocks.CORBA_DARK_BRICK_WALL, JBlocks.CORBA_DARK_BRICK_SLAB, JBlocks.CORBA_DARK_BRICK_FENCE, JBlocks.CORBA_DARK_BRICK_FENCE_GATE, JBlocks.CORBA_DARK_BRICK_PRESSURE_PLATE, JBlocks.CORBA_DARK_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.CORBA_SENTRY_BRICKS, JBlocks.CORBA_SENTRY_BRICK_STAIRS, JBlocks.CORBA_SENTRY_BRICK_WALL, JBlocks.CORBA_SENTRY_BRICK_SLAB, JBlocks.CORBA_SENTRY_BRICK_FENCE, JBlocks.CORBA_SENTRY_BRICK_FENCE_GATE, JBlocks.CORBA_SENTRY_BRICK_PRESSURE_PLATE, JBlocks.CORBA_SENTRY_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.CORBA_LIGHT_BRICKS, JBlocks.CORBA_LIGHT_BRICK_STAIRS, JBlocks.CORBA_LIGHT_BRICK_WALL, JBlocks.CORBA_LIGHT_BRICK_SLAB, JBlocks.CORBA_LIGHT_BRICK_FENCE, JBlocks.CORBA_LIGHT_BRICK_FENCE_GATE, JBlocks.CORBA_LIGHT_BRICK_PRESSURE_PLATE, JBlocks.CORBA_LIGHT_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.TERRANIAN_STONE, JBlocks.TERRANIAN_STONE_STAIRS, JBlocks.TERRANIAN_STONE_WALL, JBlocks.TERRANIAN_STONE_SLAB, JBlocks.TERRANIAN_STONE_FENCE, JBlocks.TERRANIAN_STONE_FENCE_GATE, JBlocks.TERRANIAN_STONE_PRESSURE_PLATE, JBlocks.TERRANIAN_STONE_BUTTON);
        this.addDecorType(consumer, JBlocks.TERRANIAN_DARK_PANELS, JBlocks.TERRANIAN_DARK_PANEL_STAIRS, JBlocks.TERRANIAN_DARK_PANEL_WALL, JBlocks.TERRANIAN_DARK_PANEL_SLAB, JBlocks.TERRANIAN_DARK_PANEL_FENCE, JBlocks.TERRANIAN_DARK_PANEL_FENCE_GATE, JBlocks.TERRANIAN_DARK_PANEL_PRESSURE_PLATE, JBlocks.TERRANIAN_DARK_PANEL_BUTTON);
        this.addDecorType(consumer, JBlocks.TERRANIAN_PANELS, JBlocks.TERRANIAN_PANEL_STAIRS, JBlocks.TERRANIAN_PANEL_WALL, JBlocks.TERRANIAN_PANEL_SLAB, JBlocks.TERRANIAN_PANEL_FENCE, JBlocks.TERRANIAN_PANEL_FENCE_GATE, JBlocks.TERRANIAN_PANEL_PRESSURE_PLATE, JBlocks.TERRANIAN_PANEL_BUTTON);
        this.addDecorType(consumer, JBlocks.CORBA_COBBLESTONE, JBlocks.CORBA_COBBLESTONE_STAIRS, JBlocks.CORBA_COBBLESTONE_WALL, JBlocks.CORBA_COBBLESTONE_SLAB, JBlocks.CORBA_COBBLESTONE_FENCE, JBlocks.CORBA_COBBLESTONE_FENCE_GATE, JBlocks.CORBA_COBBLESTONE_PRESSURE_PLATE, JBlocks.CORBA_COBBLESTONE_BUTTON);
        this.addDecorType(consumer, JBlocks.CORBA_BRICKS, JBlocks.CORBA_BRICK_STAIRS, JBlocks.CORBA_BRICK_WALL, JBlocks.CORBA_BRICK_SLAB, JBlocks.CORBA_BRICK_FENCE, JBlocks.CORBA_BRICK_FENCE_GATE, JBlocks.CORBA_BRICK_PRESSURE_PLATE, JBlocks.CORBA_BRICK_BUTTON);
        this.addDecorType(consumer, JBlocks.CORBA_CRACKED_BRICKS, JBlocks.CORBA_CRACKED_BRICK_STAIRS, JBlocks.CORBA_CRACKED_BRICK_WALL, JBlocks.CORBA_CRACKED_BRICK_SLAB, JBlocks.CORBA_CRACKED_BRICK_FENCE, JBlocks.CORBA_CRACKED_BRICK_FENCE_GATE, JBlocks.CORBA_CRACKED_BRICK_PRESSURE_PLATE, JBlocks.CORBA_CRACKED_BRICK_BUTTON);
    }

    public void buildQuartzTypes(RecipeOutput consumer) {
        this.addQuartzType(consumer, JItems.CRIMSON_QUARTZ, JBlocks.CRIMSON_QUARTZ_ORE, JBlocks.CRIMSON_QUARTZ_BLOCK, JBlocks.SMOOTH_CRIMSON_QUARTZ, JBlocks.CRIMSON_QUARTZ_STAIRS, JBlocks.SMOOTH_CRIMSON_QUARTZ_STAIRS, JBlocks.CRIMSON_QUARTZ_SLAB, JBlocks.SMOOTH_CRIMSON_QUARTZ_SLAB, JBlocks.CRIMSON_QUARTZ_BRICKS, JBlocks.CHISELED_CRIMSON_QUARTZ_BLOCK, JBlocks.CRIMSON_QUARTZ_PILLAR);
        this.addQuartzType(consumer, JItems.WARPED_QUARTZ, JBlocks.WARPED_QUARTZ_ORE, JBlocks.WARPED_QUARTZ_BLOCK, JBlocks.SMOOTH_WARPED_QUARTZ, JBlocks.WARPED_QUARTZ_STAIRS, JBlocks.SMOOTH_WARPED_QUARTZ_STAIRS, JBlocks.WARPED_QUARTZ_SLAB, JBlocks.SMOOTH_WARPED_QUARTZ_SLAB, JBlocks.WARPED_QUARTZ_BRICKS, JBlocks.CHISELED_WARPED_QUARTZ_BLOCK, JBlocks.WARPED_QUARTZ_PILLAR);
    }

    public void buildSmithingRecipes(RecipeOutput recipeConsumer) {
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_HELMET, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_HELMET.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_CHESTPLATE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_CHEST.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_LEGGINGS, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_LEGS.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_BOOTS, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_BOOTS.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_SWORD, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_SWORD.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_AXE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_AXE.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_PICKAXE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_PICKAXE.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_SHOVEL, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_SHOVEL.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_HOE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_HOE.get());
    }

    protected void addSmithingRecipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike modifier, Item result) {
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output) {
        this.add3x3Recipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, input, output);
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output, int count) {
        this.add3x3Recipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, input, output, count);
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike output) {
        this.add3x3Recipe(recipeConsumer, cat, input, output, 1);
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf('#'), input).pattern("###").pattern("###").pattern("###").unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, ItemLike output, int count, String name) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer, String.valueOf(this.getItemFromRegistryName(input.toString())) + name);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, ItemLike input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, TagKey<Item> input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, char s, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, char s, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).pattern(m).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, String t, String m, String b, char s, ItemLike input, ItemLike output, int count) {
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, t, m, b, s, input, output, count);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, ItemLike input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, TagKey<Item> input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, char s, ItemLike input, char s2, ItemLike input2, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).pattern(t).pattern(m).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, ItemLike output, int count) {
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, t, m, b, s, input, s2, input2, output, count);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike input2, ItemLike output, int count, String name) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).requires(input2).unlockedBy(this.inputToKey(input), this.has(input)).unlockedBy(this.inputToKey(input2), this.has(input2)).save(recipeConsumer, this.getItemFromRegistryName(output.toString()).toString() + name);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike input2, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).requires(input2).unlockedBy(this.inputToKey(input), this.has(input)).unlockedBy(this.inputToKey(input2), this.has(input2)).save(recipeConsumer);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike input2, ItemLike input3, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).requires(input2).requires(input3).unlockedBy(this.inputToKey(input), this.has(input)).unlockedBy(this.inputToKey(input2), this.has(input2)).save(recipeConsumer);
    }

    protected void addOreBlockRecipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), input).pattern("###").pattern("###").pattern("###").unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)input, (int)9).requires(output).unlockedBy(this.inputToKey(output), this.has(output)).group(input.asItem().toString()).save(recipeConsumer, String.valueOf(this.getItemFromRegistryName(input.toString())) + "_from_block");
    }

    protected void add2x2Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output, int count, boolean addReverse) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('#'), input).pattern("##").pattern("##").unlockedBy(this.inputToKey(input), this.has(input)).save(recipeConsumer);
        if (addReverse) {
            this.addShapelessRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, output, input, 4);
        }
    }

    protected void add2x2Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output, boolean addReverse) {
        this.add2x2Recipe(recipeConsumer, input, output, 1, addReverse);
    }

    public void addOreDefaultItems(RecipeOutput recipeConsumer, RecipePrefix name, ItemLike block, ItemLike oreBlock, ItemLike deepslateOre, ItemLike raw, ItemLike ingot, ItemLike stickItem) {
        this.addToolsetAndArmorRecipes(recipeConsumer, stickItem, ingot, name);
        this.addShieldRecipe(recipeConsumer, ingot, this.getItemFromRegistryName("jitl:" + name.getString() + "shield"));
        this.addOreBlockRecipe(recipeConsumer, ingot, block);
        this.addBlastingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 100, "_ore_blasting");
        this.addSmeltingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 200, "_ore_smelting");
        if (deepslateOre != null) {
            this.addBlastingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 100, "_deep_blasting");
            this.addSmeltingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 200, "_deep_smelting");
        }
        if (raw != null) {
            this.addBlastingRecipe(recipeConsumer, raw, ingot, 1.0f, 100, "_raw_blasting");
            this.addSmeltingRecipe(recipeConsumer, raw, ingot, 1.0f, 200, "_raw_smelting");
        }
    }

    public void addOreNoArmorItems(RecipeOutput recipeConsumer, RecipePrefix name, ItemLike block, ItemLike oreBlock, ItemLike deepslateOre, ItemLike raw, ItemLike ingot, ItemLike stickItem) {
        this.addToolsetRecipes(recipeConsumer, stickItem, ingot, name);
        this.addShieldRecipe(recipeConsumer, ingot, this.getItemFromRegistryName("jitl:" + name.getString() + "shield"));
        this.addOreBlockRecipe(recipeConsumer, ingot, block);
        if (oreBlock != null) {
            this.addBlastingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 100, "_ore_blasting");
            this.addSmeltingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 200, "_ore_smelting");
        }
        if (deepslateOre != null) {
            this.addBlastingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 100, "_deep_blasting");
            this.addSmeltingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 200, "_deep_smelting");
        }
        if (raw != null) {
            this.addBlastingRecipe(recipeConsumer, raw, ingot, 1.0f, 100, "_raw_blasting");
            this.addSmeltingRecipe(recipeConsumer, raw, ingot, 1.0f, 200, "_raw_smelting");
        }
    }

    protected void addToolsetAndArmorRecipes(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, RecipePrefix recipePrefix) {
        this.addToolsetRecipes(recipeConsumer, stickItem, materialItem, recipePrefix);
        this.addArmorRecipes(recipeConsumer, materialItem, recipePrefix);
    }

    protected void addToolsetRecipes(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, RecipePrefix recipePrefix) {
        this.addAxeRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "axe"));
        this.addPickaxeRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "pickaxe"));
        this.addShovelRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "shovel"));
        this.addSwordRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "sword"));
        this.addHoeRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "hoe"));
        this.addMultitoolRecipe(recipeConsumer, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "axe"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "pickaxe"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "shovel"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "hoe"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "multitool"));
    }

    public void addArmorRecipes(RecipeOutput recipeConsumer, ItemLike materialItem, RecipePrefix recipePrefix) {
        this.addHelmetRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "helmet"));
        this.addChestplateRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "chestplate"));
        this.addLeggingsRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "leggings"));
        this.addBootsRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "boots"));
    }

    public void addDecorType(RecipeOutput recipeConsumer, DeferredBlock<? extends Block> plank, DeferredBlock<? extends Block> stairs, DeferredBlock<? extends Block> wall, DeferredBlock<? extends Block> slab, DeferredBlock<? extends Block> fence, DeferredBlock<? extends Block> gate, DeferredBlock<? extends Block> pressureplate, DeferredBlock<? extends Block> button) {
        this.addStairRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)stairs.get());
        this.addWallRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)wall.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)slab.get());
        this.addFenceRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)Items.STICK, (ItemLike)fence.get());
        this.addFenceGateRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)gate.get());
        this.addPressureplateRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)pressureplate.get());
        this.buttonBuilder(recipeConsumer, (ItemLike)button.get(), (ItemLike)plank.get());
    }

    public void addWoodType(RecipeOutput recipeConsumer, DeferredBlock<? extends Block> log, DeferredBlock<? extends Block> plank, DeferredBlock<? extends Block> stairs, DeferredBlock<? extends Block> slab, DeferredBlock<? extends Block> fence, DeferredBlock<? extends Block> gate, DeferredBlock<? extends Block> trapdoor, DeferredBlock<? extends Block> pressureplate, DeferredBlock<? extends Block> door, DeferredBlock<? extends Block> button, DeferredItem<Item> boat) {
        this.addBoatRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)boat.get());
        this.addStairRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)stairs.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)slab.get());
        this.addFenceRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)Items.STICK, (ItemLike)fence.get());
        this.addFenceGateRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)gate.get());
        this.addTrapdoorRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)trapdoor.get());
        this.addPressureplateRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)pressureplate.get());
        this.addDoorRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)door.get());
        this.planksFromLogs(recipeConsumer, (ItemLike)plank.get(), (ItemLike)log.get());
        this.buttonBuilder(recipeConsumer, (ItemLike)button.get(), (ItemLike)plank.get());
    }

    public void addQuartzType(RecipeOutput recipeConsumer, DeferredItem<? extends Item> quartz, DeferredBlock<? extends Block> quartzOre, DeferredBlock<? extends Block> quartzBlock, DeferredBlock<? extends Block> smoothQuartzBlock, DeferredBlock<? extends Block> quartzStairs, DeferredBlock<? extends Block> smoothQuartzStairs, DeferredBlock<? extends Block> quartzSlab, DeferredBlock<? extends Block> smoothQuartzSlab, DeferredBlock<? extends Block> quartzBricks, DeferredBlock<? extends Block> chiseledQuartzBlock, DeferredBlock<? extends Block> quartzPillar) {
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)smoothQuartzBlock.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)quartzOre.get(), (ItemLike)quartz.get());
        this.add2x2Recipe(recipeConsumer, (ItemLike)quartz.get(), (ItemLike)quartzBlock.get(), false);
        this.addStairRecipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)quartzStairs.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)quartzSlab.get());
        this.addStairRecipe(recipeConsumer, (ItemLike)smoothQuartzBlock.get(), (ItemLike)smoothQuartzStairs.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)smoothQuartzBlock.get(), (ItemLike)smoothQuartzSlab.get());
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "s", "s", 's', (ItemLike)quartzSlab.get(), (ItemLike)chiseledQuartzBlock.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "s", "s", 's', (ItemLike)quartzBlock.get(), (ItemLike)quartzPillar.get(), 2);
        this.add2x2Recipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)quartzBricks.get(), 4, false);
    }

    protected void buttonBuilder(RecipeOutput recipeConsumer, ItemLike button, ItemLike material) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)button).requires(material).unlockedBy(this.inputToKey(material), this.has(material)).save(recipeConsumer);
    }

    protected void planksFromLogs(RecipeOutput finishedRecipeConsumer, ItemLike planks, ItemLike logs) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)4).requires(logs).unlockedBy(this.inputToKey(logs), this.has(logs)).save(finishedRecipeConsumer);
    }

    protected void addStick(RecipeOutput recipeConsumer, ItemLike materialItem) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)4).define(Character.valueOf('#'), materialItem).pattern("#").pattern("#").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_stick");
    }

    protected void addDoorRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("##").pattern("##").pattern("##").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addPressureplateRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("##").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addTrapdoorRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("###").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addFenceGateRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#I#").pattern("#I#").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addFenceRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#I#").pattern("#I#").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addSlabRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).define(Character.valueOf('#'), materialItem).pattern("###").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addStairRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("#  ").pattern("## ").pattern("###").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addWallRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("###").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addBoatRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("# #").pattern("###").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addPickaxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("###").pattern(" I ").pattern(" I ").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_pickaxe");
        } else {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("###").pattern(" I ").pattern(" I ").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
        }
    }

    protected void addShovelRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("I").pattern("I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_shovel");
        } else {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("I").pattern("I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
        }
    }

    protected void addAxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern("#I").pattern(" I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_axe");
        } else {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern("#I").pattern(" I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
        }
    }

    protected void addHoeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern(" I").pattern(" I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_hoe");
        } else {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern(" I").pattern(" I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
        }
    }

    protected void addMultitoolRecipe(RecipeOutput recipeConsumer, ItemLike axe, ItemLike pick, ItemLike shovel, ItemLike hoe, ItemLike output) {
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).requires(axe).requires(pick).requires(shovel).requires(hoe).unlockedBy(this.inputToKey(axe), this.has(axe)).save(recipeConsumer);
    }

    protected void addSwordRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("#").pattern("I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_sword");
        } else {
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("#").pattern("I").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
        }
    }

    protected void addPickaxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addPickaxeRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addShovelRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addShovelRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addAxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addAxeRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addHoeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addHoeRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addSwordRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addSwordRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addShieldRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('M'), materialItem).pattern("#M#").pattern("###").pattern(" # ").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addHelmetRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("# #").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addChestplateRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("# #").pattern("###").pattern("###").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addLeggingsRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("# #").pattern("# #").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addBootsRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("# #").pattern("# #").unlockedBy(this.inputToKey(materialItem), this.has(materialItem)).save(recipeConsumer);
    }

    protected void addSmeltingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time, String name) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)time).unlockedBy(this.inputToKey(input), this.has(input)).save(consumer, output.asItem().getDescriptionId() + name);
    }

    protected void addBlastingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time, String name) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)time).unlockedBy(this.inputToKey(input), this.has(input)).save(consumer, output.asItem().getDescriptionId() + name);
    }

    protected void addSmeltingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time) {
        this.addSmeltingRecipe(consumer, input, output, xpGiven, time, "");
    }

    protected void addBlastingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time) {
        this.addBlastingRecipe(consumer, input, output, xpGiven, time, "");
    }

    protected void addSmeltingAndBlastingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        this.addSmeltingRecipe(consumer, input, output, 1.0f, 200, "_smelting");
        this.addBlastingRecipe(consumer, input, output, 1.0f, 100, "_blasting");
    }

    protected void addCookingRecipe(ItemLike input, ItemLike output, float xpGiven) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)100);
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)600);
    }

    protected String inputToKey(ItemLike input) {
        return "has_item";
    }

    public ItemLike getItemFromRegistryName(String registryName) {
        ItemLike item = (ItemLike)BuiltInRegistries.ITEM.getValue(ResourceLocation.parse((String)registryName));
        return item;
    }

    public static enum RecipePrefix {
        SAPPHIRE("sapphire_"),
        LUNIUM("lunium_"),
        SHADIUM("shadium_"),
        BLOODCRUST("bloodcrust_"),
        CELESTIUM("celestium_"),
        STORON("storon_"),
        KORITE("korite_"),
        MEKYUM("mekyum_"),
        FLAIRIUM("flairium_"),
        DES("des_"),
        ORBADITE("orbadite_"),
        GORBITE("gorbite_"),
        SOULSTONE("soulstone_"),
        WOODEN("wooden_");

        String prefix;

        private RecipePrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getString() {
            return this.prefix;
        }
    }
}

