/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockPortalGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockNSModelWriter;
    protected BufferedWriter blockEWModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.portalBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockNSModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_ns.json";
            String blockEWModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_ew.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockNSModel = new File(blockNSModelDir);
            File blockEWModel = new File(blockEWModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockNSModel.exists()) {
                    blockNSModel.delete();
                }
                blockNSModel.createNewFile();
                this.blockNSModelWriter = new BufferedWriter(new FileWriter(blockNSModel));
                if (blockEWModel.exists()) {
                    blockEWModel.delete();
                }
                blockEWModel.createNewFile();
                this.blockEWModelWriter = new BufferedWriter(new FileWriter(blockEWModelDir));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockNSModel("jitl", name);
            this.getBlockEWModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(name, "_ns");
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "_ns\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockNSModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockNSModelWriter, "{");
        this.writeToBlockModelFile(this.blockNSModelWriter, "  \"parent\": \"minecraft:block/nether_portal_ns\",");
        this.writeToBlockModelFile(this.blockNSModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockNSModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockNSModelWriter, "    \"portal\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockNSModelWriter, "  }");
        this.writeToBlockModelFile(this.blockNSModelWriter, "}");
    }

    public void getBlockEWModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockEWModelWriter, "{");
        this.writeToBlockModelFile(this.blockEWModelWriter, "  \"parent\": \"minecraft:block/nether_portal_ew\",");
        this.writeToBlockModelFile(this.blockEWModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockEWModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile(this.blockEWModelWriter, "    \"portal\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile(this.blockEWModelWriter, "  }");
        this.writeToBlockModelFile(this.blockEWModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"axis=x\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_ns\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"axis=z\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_ew\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockEWModelWriter.close();
            this.blockNSModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter w, String text) {
        try {
            w.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

