/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.data.BasicFileGenerator;
import net.jitl.core.init.internal.JBlocks;

public class JBlockTrophyGenerator
extends BasicFileGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.trophyBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.generateBasicFile(true, name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"minecraft:item/generated\",");
        this.writeToItemModelFile("  \"textures\": {");
        this.writeToItemModelFile("      \"layer0\": \"" + modID + ":item/" + name + "\"");
        this.writeToItemModelFile("  }");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("    \"textures\": {");
        this.writeToBlockModelFile("        \"particle\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile("        \"0\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockModelFile("        \"1\": \"" + modID + ":block/" + name + "_front\",");
        this.writeToBlockModelFile("        \"2\": \"" + modID + ":block/" + name + "_side\"");
        this.writeToBlockModelFile("    },");
        this.writeToBlockModelFile("    \"elements\": [");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"base\",");
        this.writeToBlockModelFile("            \"from\": [ 2.0, 0.0, 2.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 14.0, 1.0, 14.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 12.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 12.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"base1\",");
        this.writeToBlockModelFile("            \"from\": [ 4.0, 1.0, 4.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 12.0, 3.0, 12.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"shaft\",");
        this.writeToBlockModelFile("            \"from\": [ 7.0, 3.0, 7.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 9.0, 9.0, 9.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 6.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 6.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 6.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 6.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 6.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 6.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"trophy1\",");
        this.writeToBlockModelFile("            \"from\": [ 4.0, 9.0, 4.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 12.0, 11.0, 12.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 8.0, 2.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"trophyBottom\",");
        this.writeToBlockModelFile("            \"from\": [ 2.0, 11.0, 2.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 14.0, 12.0, 14.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"sidefront\",");
        this.writeToBlockModelFile("            \"from\": [ 2.0, 12.0, 1.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 14.0, 22.0, 2.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#1\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"side1\",");
        this.writeToBlockModelFile("            \"from\": [ 1.0, 12.0, 2.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 2.0, 22.0, 14.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 4.0, 7.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 2.0, 0.0, 3.0, 12.0] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 2.0, 0.0, 3.0, 12.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"side2\",");
        this.writeToBlockModelFile("            \"from\": [ 2.0, 12.0, 14.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 14.0, 22.0, 15.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 12.0, 1.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"side3\",");
        this.writeToBlockModelFile("            \"from\": [ 14.0, 12.0, 2.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 15.0, 22.0, 14.0 ], ");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 10.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#2\", \"uv\": [ 2.0, 3.0, 14.0, 13.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 12.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 1.0, 12.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"handle1\",");
        this.writeToBlockModelFile("            \"from\": [ -1.0, 14.0, 7.0 ], ");
        this.writeToBlockModelFile("            \"to\": [ 1.0, 23.0, 9.0 ], ");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 2.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        },");
        this.writeToBlockModelFile("        {");
        this.writeToBlockModelFile("            \"name\": \"handle2\",");
        this.writeToBlockModelFile("            \"from\": [ 15.0, 14.0, 7.0 ],");
        this.writeToBlockModelFile("            \"to\": [ 17.0, 23.0, 9.0 ],");
        this.writeToBlockModelFile("            \"faces\": {");
        this.writeToBlockModelFile("                \"north\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"east\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"south\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"west\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 9.0 ] },");
        this.writeToBlockModelFile("                \"up\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 2.0 ] },");
        this.writeToBlockModelFile("                \"down\": { \"texture\": \"#0\", \"uv\": [ 0.0, 0.0, 2.0, 2.0 ] }");
        this.writeToBlockModelFile("            }");
        this.writeToBlockModelFile("        }");
        this.writeToBlockModelFile("    ]");
        this.writeToBlockModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"facing=east\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("    \"facing=north\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("    \"facing=south\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("     },");
        this.writeToBlockstateFile("    \"facing=west\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("     }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

