/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper.internal;

import java.lang.reflect.Field;
import net.jitl.core.helper.internal.ReflectionHelper;
import org.jetbrains.annotations.Nullable;

public class UnlockedField<O, T> {
    private final Field field;
    private final boolean isStatic;
    private final Boolean finalSettable;
    private final boolean accessible;
    private final boolean isFinal;

    public UnlockedField(Field field) {
        this.field = field;
        this.isFinal = ReflectionHelper.isFinal(field);
        this.isStatic = ReflectionHelper.isStatic(field);
        this.finalSettable = this.predictFinalSettable();
        this.accessible = field.trySetAccessible();
    }

    private Boolean predictFinalSettable() {
        if (this.isFinal) {
            return !this.isStatic && !this.field.getDeclaringClass().isHidden() && !this.field.getDeclaringClass().isRecord();
        }
        return null;
    }

    public T get(@Nullable O fieldOwner) {
        this.validateAccessible(AccessType.GET, true);
        if (!this.isStatic && fieldOwner == null) {
            throw new IllegalArgumentException(String.format("Tried to pass null as a fieldOwner to the non static field %s", this.field.toString()));
        }
        try {
            return (T)this.field.get(fieldOwner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(@Nullable O fieldOwner, T newVal) {
        this.validateAccessible(AccessType.SET, true);
        if (!this.isStatic && fieldOwner == null) {
            throw new IllegalArgumentException(String.format("Tried to pass null as a fieldOwner to the non static field %s", this.field.toString()));
        }
        try {
            this.field.set(fieldOwner, newVal);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Field unboxed() {
        return this.field;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean guessIsAccessible(AccessType accessType) {
        return this.validateAccessible(accessType, false);
    }

    private boolean validateAccessible(AccessType accessType, boolean strict) {
        if (accessType == AccessType.SET && this.isFinal && !this.finalSettable.booleanValue()) {
            if (!strict) {
                return false;
            }
            throw new UnsupportedOperationException(String.format("Final field object may have (but not necessarily) write access if at least:\nthe field is non-static (%b);\nthe field's declaring class is not a hidden class (%b);\nthe field's declaring class is not a record class (%b).\n", !this.isStatic, !this.field.getDeclaringClass().isHidden(), !this.field.getDeclaringClass().isRecord()));
        }
        if (!this.accessible) {
            if (!strict) {
                return false;
            }
            throw new UnsupportedOperationException("The field isn't accessible");
        }
        return true;
    }

    public static enum AccessType {
        GET,
        SET;

    }
}

