/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.network;

import net.jitl.common.capability.keypressed.PressedKeyCap;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketKeyPressed(boolean isAmuletPressed, boolean isGearPressed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketKeyPressed> TYPE = new CustomPacketPayload.Type(JITL.rl("key_pressed"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketKeyPressed> STREAM_CODEC = CustomPacketPayload.codec(PacketKeyPressed::write, PacketKeyPressed::decode);

    public static PacketKeyPressed decode(FriendlyByteBuf buffer) {
        return new PacketKeyPressed(buffer.readBoolean(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isAmuletPressed);
        buffer.writeBoolean(this.isGearPressed);
    }

    public static void handle(PacketKeyPressed payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ((PressedKeyCap)context.player().getData(JDataAttachments.KEY_PRESSED)).setAmuletPressed(payload.isAmuletPressed);
            ((PressedKeyCap)context.player().getData(JDataAttachments.KEY_PRESSED)).setArmorPressed(payload.isGearPressed);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

