/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.List;
import net.jitl.client.util.GuiHelper;
import net.jitl.core.helper.EnumSummoningRecipes;
import net.jitl.core.helper.internal.EmptyContainer;
import net.jitl.core.init.JITL;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class JRecipeBookGUI
extends AbstractContainerScreen<EmptyContainer> {
    private PageButton nextButton;
    private PageButton previousButton;
    private final ResourceLocation RECIPE = JITL.rl("textures/gui/summoning_table_recipe.png");
    private final ResourceLocation BACKGROUND = JITL.rl("textures/gui/recipe_book.png");
    public int pageNumber = 0;

    public JRecipeBookGUI(Inventory playerInventory) {
        super((AbstractContainerMenu)new EmptyContainer(), playerInventory, (Component)Component.translatable((String)""));
        this.imageWidth = 242;
        this.imageHeight = 216;
    }

    protected void init() {
        super.init();
        int w1 = (this.width - this.imageWidth) / 2;
        int h1 = (this.height - this.imageHeight) / 2;
        int xPos = w1 + 95;
        int yPos = h1 + 198;
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(xPos + 28, yPos, true, button -> this.flipPage(true), true));
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(xPos, yPos, false, button -> this.flipPage(false), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        int maxPages = 5;
        this.nextButton.visible = true;
        this.previousButton.visible = true;
        this.nextButton.active = this.pageNumber != maxPages;
        this.previousButton.active = this.pageNumber != 0;
    }

    protected void flipPage(boolean forward) {
        this.pageNumber = forward ? ++this.pageNumber : --this.pageNumber;
        this.updateButtonVisibility();
    }

    protected void renderBg(@NotNull GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        assert (this.minecraft != null);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.minecraft.getTextureManager().getTexture(this.BACKGROUND).getTextureView());
        GuiHelper.drawTexture(poseStack, this.BACKGROUND, x, y, 0, 0, this.imageWidth, this.imageHeight, 256, 256);
        switch (this.pageNumber) {
            case 0: {
                this.page1(poseStack, mouseX, mouseY);
                break;
            }
            case 1: {
                this.page2(poseStack, mouseX, mouseY);
                break;
            }
        }
    }

    public void page1(GuiGraphics stack, int mouseX, int mouseY) {
        int w = 120;
        int x = -3;
        int y = -3;
        this.drawSprite(stack, mouseX, mouseY, x, y, EnumSummoningRecipes.OKOLOO);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.WITHERING_BEAST);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.CALCIA);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.SOUL_WATCHER);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.CORALLATOR);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.BLAZIER);
    }

    public void page2(GuiGraphics stack, int mouseX, int mouseY) {
        int w = 120;
        int x = -3;
        int y = -3;
        this.drawSprite(stack, mouseX, mouseY, x, y, EnumSummoningRecipes.THUNDERBIRD);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.SCALE);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.LOGGER);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.SENTRY_KING);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.TERRASTAR);
        x += w;
    }

    public void drawSprite(GuiGraphics matrixStack, int mouseX, int mouseY, int x, int y, EnumSummoningRecipes recipe) {
        int k = (this.width - this.imageWidth) / 2 + 3;
        int l = (this.height - this.imageHeight) / 2 + 3;
        x = x + k + 10;
        y = y + l + 10;
        assert (this.minecraft != null);
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)this.minecraft.getTextureManager().getTexture(this.RECIPE).getTextureView());
        GuiHelper.drawTexture(matrixStack, this.RECIPE, x - 5, y - 5, 0, 0, 112, 62, 256, 256);
        matrixStack.pose().pushMatrix();
        this.renderItem(matrixStack, mouseX, mouseY, x, y, recipe, 0);
        this.renderItem(matrixStack, mouseX, mouseY, x, y += 18, recipe, 1);
        this.renderItem(matrixStack, mouseX, mouseY, x += 18, y, recipe, 3);
        this.renderItem(matrixStack, mouseX, mouseY, x -= 18, y += 18, recipe, 2);
        this.renderItem(matrixStack, mouseX, mouseY, x += 36, y -= 36, recipe, 4);
        this.renderItem(matrixStack, mouseX, mouseY, x, y += 18, recipe, 5);
        this.renderItem(matrixStack, mouseX, mouseY, x, y += 18, recipe, 6);
        this.renderItem(matrixStack, mouseX, mouseY, x + 46, y -= 18, recipe, 7);
        matrixStack.pose().popMatrix();
    }

    public void renderItem(GuiGraphics matrixStack, int mouseX, int mouseY, int x, int y, EnumSummoningRecipes recipe, int index) {
        ItemStack item = new ItemStack((ItemLike)recipe.getItem(index));
        matrixStack.renderItem(item, x, y);
        if (this.isMouseOver(mouseX, mouseY, x, y)) {
            this.renderTooltip(matrixStack, mouseX, mouseY, item);
        }
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY, ItemStack item) {
        Component component = item.getStyledHoverName();
        ClientTooltipComponent clienttooltipcomponent = ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText());
        pGuiGraphics.renderTooltip(this.font, List.of(clienttooltipcomponent), pX, pY, DefaultTooltipPositioner.INSTANCE, (ResourceLocation)item.get(DataComponents.TOOLTIP_STYLE));
    }

    protected boolean isMouseOver(int mouseX, int mouseY, int spriteX, int spriteY) {
        if (mouseX >= spriteX && mouseX <= spriteX + 16 && mouseY >= spriteY) {
            return mouseY <= spriteY + 16;
        }
        return false;
    }

    protected void containerTick() {
        super.containerTick();
        this.nextButton.active = this.pageNumber < 1;
        this.previousButton.active = this.pageNumber > 0;
    }

    protected void renderLabels(@NotNull GuiGraphics matrixStack, int x, int y) {
    }
}

