/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.BoatRenderState;
import net.minecraft.util.Mth;

public class JBoatModel
extends EntityModel<BoatRenderState> {
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;

    public JBoatModel(ModelPart root) {
        super(root);
        this.leftPaddle = root.getChild("left_paddle");
        this.rightPaddle = root.getChild("right_paddle");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 19).addBox(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-15.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)4.712389f, (float)0.0f));
        partdefinition.addOrReplaceChild("front", CubeListBuilder.create().texOffs(0, 27).addBox(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)15.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        partdefinition.addOrReplaceChild("right", CubeListBuilder.create().texOffs(0, 35).addBox(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        partdefinition.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 43).addBox(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)9.0f));
        partdefinition.addOrReplaceChild("left_paddle", CubeListBuilder.create().texOffs(62, 0).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).addBox(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partdefinition.addOrReplaceChild("right_paddle", CubeListBuilder.create().texOffs(62, 20).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).addBox(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        partdefinition.addOrReplaceChild("water_patch", CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(BoatRenderState boat) {
        super.setupAnim((Object)boat);
        JBoatModel.animatePaddle(boat.rowingTimeLeft, 0, this.leftPaddle);
        JBoatModel.animatePaddle(boat.rowingTimeRight, 1, this.rightPaddle);
    }

    private static void animatePaddle(float p_376567_, int p_376720_, ModelPart p_376932_) {
        p_376932_.xRot = Mth.clampedLerp((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.sin((float)(-p_376567_)) + 1.0f) / 2.0f));
        p_376932_.yRot = Mth.clampedLerp((float)-0.7853982f, (float)0.7853982f, (float)((Mth.sin((float)(-p_376567_ + 1.0f)) + 1.0f) / 2.0f));
        if (p_376720_ == 1) {
            p_376932_.yRot = (float)Math.PI - p_376932_.yRot;
        }
    }
}

