/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.jitl.common.entity.base.JAnimalEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public class AnimatedAnimalRenderer<T extends LivingEntityRenderState & GeoRenderState>
extends GeoEntityRenderer<JAnimalEntity, T> {
    private float size = 1.0f;

    public AnimatedAnimalRenderer(EntityRendererProvider.Context renderManager, GeoModel<JAnimalEntity> modelProvider) {
        super(renderManager, modelProvider);
        this.shadowRadius = 0.5f;
    }

    public AnimatedAnimalRenderer(EntityRendererProvider.Context renderManager, GeoModel<JAnimalEntity> modelProvider, float shadow, float size) {
        super(renderManager, modelProvider);
        this.shadowRadius = shadow;
        this.size = size;
    }

    public AnimatedAnimalRenderer(EntityRendererProvider.Context renderManager, GeoModel<JAnimalEntity> modelProvider, float shadow) {
        super(renderManager, modelProvider);
        this.shadowRadius = shadow;
    }

    public void preRender(T renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (((LivingEntityRenderState)renderState).isBaby) {
            this.size = 0.5f;
        }
        poseStack.scale(this.size, this.size, this.size);
        super.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T instance) {
        return this.getGeoModel().getTextureResource((GeoRenderState)instance);
    }
}

