/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.entity.overworld;

import com.mojang.blaze3d.vertex.PoseStack;
import net.jitl.client.render.entity.overworld.state.BoomRenderState;
import net.jitl.common.entity.overworld.BoomBoom;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BoomBoomRenderer<T extends BoomRenderState>
extends GeoEntityRenderer<BoomBoom, T> {
    public BoomBoomRenderer(EntityRendererProvider.Context renderManager, DefaultedEntityGeoModel<BoomBoom> modelProvider) {
        super(renderManager, modelProvider);
        this.shadowRadius = 0.5f;
    }

    public void scale(T pLivingEntity, PoseStack pMatrixStack) {
        float f = ((BoomRenderState)((Object)pLivingEntity)).swelling;
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        pMatrixStack.scale(f2, f3, f2);
    }

    public T createRenderState(BoomBoom animatable, Void relatedObject) {
        return (T)((Object)new BoomRenderState());
    }

    public void preRender(T renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        this.scale(renderState, poseStack);
        super.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
    }

    public void extractRenderState(BoomBoom e, T state, float ticks) {
        super.extractRenderState((Entity)e, state, ticks);
        ((BoomRenderState)((Object)state)).swelling = e.getSwelling(ticks);
        ((BoomRenderState)((Object)state)).isPowered = e.isPowered();
    }
}

