/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jitl.client.render.world.JDimensionSpecialEffects;
import net.jitl.client.render.world.clouds.JCloudRenderer;
import net.jitl.core.init.JITL;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.client.renderer.state.SkyRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CorbaRenderInfo
extends JDimensionSpecialEffects {
    private static final ResourceLocation SKY_LOCATION = JITL.rl("textures/environment/corba_sky.png");
    private static final ResourceLocation BOIL_MOON_LOCATION = JITL.rl("textures/environment/boil_moon1.png");
    private static final ResourceLocation EUCA_MOON_LOCATION = JITL.rl("textures/environment/euca_moon1.png");

    public CorbaRenderInfo() {
        super(DimensionSpecialEffects.SkyType.END, true, false);
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 vector3d, float float_) {
        float color = 1.0f;
        return vector3d.multiply((double)(float_ * color), (double)(float_ * color), (double)(float_ * color));
    }

    @Override
    public JCloudRenderer getCloudRenderer() {
        return new JCloudRenderer(JITL.rl("textures/environment/corba_clouds.png"));
    }

    public boolean isFoggyAt(int i, int i2) {
        return false;
    }

    public boolean renderSky(LevelRenderState levelRenderState, SkyRenderState skyRenderState, Matrix4f modelViewMatrix, Runnable setupFog) {
        setupFog.run();
        PoseStack posestack = new PoseStack();
        this.renderSky(SKY_LOCATION, 3.0f);
        posestack.pushPose();
        posestack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(20.0f));
        posestack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-30.0f));
        this.renderSun(15.0f, 1.0f, posestack, BOIL_MOON_LOCATION);
        posestack.popPose();
        posestack.pushPose();
        posestack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-80.0f));
        posestack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-10.0f));
        this.renderSun(50.0f, 1.0f, posestack, EUCA_MOON_LOCATION);
        posestack.popPose();
        return true;
    }
}

