/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.util;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix3x2fStack;

public class GuiHelper {
    public static void drawString(GuiGraphics graphics, String text, int x, int y, int colour, boolean shadow) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, colour, shadow);
    }

    public static void drawString(GuiGraphics graphics, Component text, int x, int y, int colour, boolean shadow) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, colour, shadow);
    }

    public static void drawString(GuiGraphics graphics, FormattedCharSequence text, int x, int y, int colour, boolean shadow) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, colour, shadow);
    }

    public static void drawTexture(GuiGraphics graphics, ResourceLocation texture, int x, int y, int u, int v, int width, int height, int texWidth, int texHeight) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, (float)u, (float)v, width, height, texWidth, texHeight);
    }

    public static void drawCenteredStringWithCustomScale(GuiGraphics gui, Font f, FormattedText comp, int x, int y, int colour, float size, int availableHeight) {
        float f2;
        gui.pose().pushMatrix();
        Matrix3x2fStack matrix3x2fStack = gui.pose();
        float f3 = (float)((double)x - (double)f.width(comp) / 2.0 * (double)size);
        double d = (double)y + (double)availableHeight / 2.0;
        Objects.requireNonNull(f);
        if (9.0f * size > 1.0f) {
            Objects.requireNonNull(f);
            f2 = (float)(-1 * 9) * size;
        } else {
            Objects.requireNonNull(f);
            f2 = 9.0f * size;
        }
        matrix3x2fStack.translate(f3, (float)(d + (double)f2 * 0.5));
        gui.pose().scale(size, size);
        GuiHelper.drawString(gui, comp.getString(), 0, 0, colour, false);
        gui.pose().popMatrix();
    }
}

