/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JDoublePlantBlock
extends DoublePlantBlock {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public JDoublePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, @NotNull LevelReader worldIn, @NotNull BlockPos pos) {
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return this.mayPlaceOn(state, (BlockGetter)worldIn, pos);
        }
        BlockState blockstate = worldIn.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return this.mayPlaceOn(state, (BlockGetter)worldIn, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean canPlace(BlockState ground) {
        return ground.is(BlockTags.DIRT);
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockPos groundPos = pos.below();
        BlockState groundState = worldIn.getBlockState(groundPos);
        return this.canPlace(groundState);
    }
}

