/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.jitl.common.items.base.MultitoolItem;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.BlockHitResult;

public class JGrassBlock
extends Block {
    public JGrassBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Item itemstack = pPlayer.getItemInHand(pHand).getItem();
        Block dirt = this.getFarmlandFromGrass();
        if (itemstack instanceof HoeItem || itemstack instanceof MultitoolItem) {
            if (dirt != null) {
                pLevel.playSound((Entity)pPlayer, pPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!pLevel.isClientSide()) {
                    pLevel.setBlock(pPos, dirt.defaultBlockState(), 2);
                    if (!pPlayer.isCreative()) {
                        pPlayer.getItemInHand(pHand).hurtAndBreak(1, (LivingEntity)pPlayer, EquipmentSlot.MAINHAND);
                    }
                }
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    public Block getFarmlandFromGrass() {
        Block farmland = null;
        if (this == JBlocks.GOLDITE_GRASS.get() || this == JBlocks.EUCA_GOLD_GRASS.get()) {
            farmland = (Block)JBlocks.GOLDITE_FARMLAND.get();
        }
        if (this == JBlocks.GRASSY_PERMAFROST.get()) {
            farmland = (Block)JBlocks.PERMAFROST_FARMLAND.get();
        }
        if (this == JBlocks.DEPTHS_GRASS.get()) {
            farmland = (Block)JBlocks.DEPTHS_FARMLAND.get();
        }
        if (this == JBlocks.CORBA_GRASS.get()) {
            farmland = (Block)JBlocks.CORBA_FARMLAND.get();
        }
        if (this == JBlocks.TERRANIAN_GRASS.get()) {
            farmland = (Block)JBlocks.TERRANIAN_GRASS.get();
        }
        if (this == JBlocks.CLOUDIA_GRASS.get()) {
            farmland = (Block)JBlocks.CLOUDIA_GRASS.get();
        }
        return farmland;
    }

    public Block getDirtFromGrass() {
        Block dirt = null;
        if (this == JBlocks.GOLDITE_GRASS.get() || this == JBlocks.EUCA_GOLD_GRASS.get()) {
            dirt = (Block)JBlocks.GOLDITE_DIRT.get();
        }
        if (this == JBlocks.GRASSY_PERMAFROST.get()) {
            dirt = (Block)JBlocks.CRUMBLED_PERMAFROST.get();
        }
        if (this == JBlocks.CHARRED_GRASS.get()) {
            dirt = (Block)JBlocks.RUBBLE.get();
        }
        if (this == JBlocks.DEPTHS_GRASS.get()) {
            dirt = (Block)JBlocks.DEPTHS_DIRT.get();
        }
        if (this == JBlocks.CORBA_GRASS.get()) {
            dirt = (Block)JBlocks.CORBA_DIRT.get();
        }
        if (this == JBlocks.TERRANIAN_GRASS.get()) {
            dirt = (Block)JBlocks.TERRANIAN_DIRT.get();
        }
        if (this == JBlocks.CLOUDIA_GRASS.get()) {
            dirt = (Block)JBlocks.CLOUDIA_DIRT.get();
        }
        return dirt;
    }

    private static boolean canBeGrass(BlockState pState, LevelReader pLevelReader, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        BlockState blockstate = pLevelReader.getBlockState(blockpos);
        int i = LightEngine.getLightBlockInto((BlockState)pState, (BlockState)blockstate, (Direction)Direction.UP, (int)blockstate.getLightBlock());
        return i < 15;
    }

    private static boolean canPropagate(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        return JGrassBlock.canBeGrass(pState, pLevel, pPos) && !pLevel.getFluidState(blockpos).is(FluidTags.WATER);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!JGrassBlock.canBeGrass(pState, (LevelReader)pLevel, pPos)) {
            if (!pLevel.isAreaLoaded(pPos, 1)) {
                return;
            }
            pLevel.setBlockAndUpdate(pPos, this.getDirtFromGrass().defaultBlockState());
        } else {
            if (!pLevel.isAreaLoaded(pPos, 3)) {
                return;
            }
            if (pLevel.getMaxLocalRawBrightness(pPos.above()) >= 9) {
                BlockState blockstate = this.defaultBlockState();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pPos.offset(pRandom.nextInt(3) - 1, pRandom.nextInt(5) - 3, pRandom.nextInt(3) - 1);
                    if (!pLevel.getBlockState(blockpos).is(this.getDirtFromGrass()) || !JGrassBlock.canPropagate(blockstate, (LevelReader)pLevel, blockpos)) continue;
                    pLevel.setBlock(blockpos, blockstate, 4);
                }
            }
        }
    }
}

