/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.jitl.common.block.JTileContainerBlock;
import net.jitl.common.block.entity.PedestalTile;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PedestalBlock
extends JTileContainerBlock {
    private static final VoxelShape PEDESTAL = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOTTOM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape TOP = Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)PEDESTAL, (VoxelShape[])new VoxelShape[]{BOTTOM, TOP});

    public PedestalBlock(BlockBehaviour.Properties props) {
        super(props, PedestalTile::new);
    }

    @NotNull
    public VoxelShape getShape(BlockState s, BlockGetter b, BlockPos p, CollisionContext c) {
        return SHAPE;
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        PedestalTile pedestal;
        Item heldItem = player.getMainHandItem().getItem();
        if (worldIn.getBlockEntity(pos) instanceof PedestalTile && (pedestal = (PedestalTile)worldIn.getBlockEntity(pos)) != null) {
            pedestal.getItem(0);
            if (!worldIn.isClientSide()) {
                worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.4f), (double)((float)pos.getZ() + 0.5f), pedestal.getItem(0)));
            }
            pedestal.setItem(0, ItemStack.EMPTY);
            if (this == JBlocks.FROZEN_PEDESTAL.get() && heldItem == JItems.FROSTBORN_SOUL.get()) {
                pedestal.setItem(0, new ItemStack((ItemLike)heldItem));
                worldIn.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
            }
            if (this == JBlocks.ROYAL_PEDESTAL.get() && heldItem == JItems.EUCA_TABLET.get() || heldItem == JItems.ROYAL_DISK.get() || heldItem == JItems.METAL_DISK.get()) {
                pedestal.setItem(0, new ItemStack((ItemLike)heldItem));
                worldIn.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
            }
        }
        return InteractionResult.SUCCESS_SERVER;
    }
}

