/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import com.mojang.serialization.MapCodec;
import net.jitl.common.block.entity.JFurnaceTile;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class JFurnaceBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<JFurnaceBlock> CODEC = JFurnaceBlock.simpleCodec(JFurnaceBlock::new);

    public JFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }

    protected void openContainer(Level l, BlockPos b, Player p) {
        BlockEntity e = l.getBlockEntity(b);
        if (e instanceof JFurnaceTile) {
            p.openMenu((MenuProvider)e);
            p.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
    }

    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new JFurnaceTile(p, s);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level l, @NotNull BlockState s, @NotNull BlockEntityType<T> e) {
        return JFurnaceBlock.createFurnaceTicker((Level)l, e, (BlockEntityType)((BlockEntityType)JBlockEntities.JFURNACE.get()));
    }

    public void animateTick(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            Direction.Axis direction$axis = direction.getAxis();
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }
}

