/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;

public class JLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IShearable {
    public static final int MAX_DISTANCE = 12;
    public static final IntegerProperty DISTANCE = IntegerProperty.create((String)"jitl_leaf_distance", (int)1, (int)12);
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final float leafParticleChance = 0.01f;
    public final int particleColour;

    public JLeavesBlock(BlockBehaviour.Properties props, int particleColour) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(12))).setValue((Property)PERSISTENT, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.particleColour = particleColour;
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)DISTANCE) == 12 && (Boolean)pState.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.decaying(state)) {
            JLeavesBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, false);
        }
    }

    protected boolean decaying(BlockState s) {
        return (Boolean)s.getValue((Property)PERSISTENT) == false && (Integer)s.getValue((Property)DISTANCE) == 12;
    }

    public void tick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        level.setBlock(pos, JLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    protected int getLightBlock(BlockState state) {
        return 1;
    }

    public BlockState updateShape(BlockState stateIn, LevelReader reader, ScheduledTickAccess tick, BlockPos currentPos, Direction dir, BlockPos facingPos, BlockState state, RandomSource source) {
        int i;
        if (!stateIn.canSurvive(reader, currentPos)) {
            tick.scheduleTick(currentPos, (Block)this, 1);
        }
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            tick.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(reader));
        }
        if ((i = JLeavesBlock.getDistanceAt(state) + 1) != 1 || (Integer)stateIn.getValue((Property)DISTANCE) != i) {
            tick.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(stateIn, reader, tick, currentPos, dir, facingPos, state, source);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 12;
        BlockPos.MutableBlockPos b = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            b.setWithOffset((Vec3i)pos, direction);
            i = Math.min(i, JLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)b)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (neighbor.is(BlockTags.LOGS)) {
            return 0;
        }
        return neighbor.getBlock() instanceof JLeavesBlock || neighbor.getBlock() instanceof LeavesBlock ? (Integer)neighbor.getValue((Property)DISTANCE) : 12;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        JLeavesBlock.makeDrippingWaterParticles(level, pos, random, blockstate, blockpos);
        this.makeFallingLeavesParticles(level, pos, random, blockstate, blockpos);
    }

    private static void makeDrippingWaterParticles(Level p_394137_, BlockPos p_394032_, RandomSource p_393792_, BlockState p_393464_, BlockPos p_393946_) {
        if (!(!p_394137_.isRainingAt(p_394032_.above()) || p_393792_.nextInt(15) != 1 || p_393464_.canOcclude() && p_393464_.isFaceSturdy((BlockGetter)p_394137_, p_393946_, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)p_394137_, (BlockPos)p_394032_, (RandomSource)p_393792_, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    private void makeFallingLeavesParticles(Level level, BlockPos pos, RandomSource random, BlockState state, BlockPos pos2) {
        if (!(random.nextFloat() >= this.leafParticleChance) && !JLeavesBlock.isFaceFull((VoxelShape)state.getCollisionShape((BlockGetter)level, pos2), (Direction)Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)this.particleColour));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.TRUE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return JLeavesBlock.updateDistance(blockstate, (LevelAccessor)pContext.getLevel(), pContext.getClickedPos());
    }
}

