/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import java.util.Objects;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class JChestBlockEntity
extends ChestBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(@NotNull Level level2, @NotNull BlockPos blockPos2, @NotNull BlockState blockState2) {
            JChestBlockEntity.playSound(level2, blockPos2, blockState2, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(@NotNull Level level1, @NotNull BlockPos blockPos1, @NotNull BlockState blockState1) {
            JChestBlockEntity.playSound(level1, blockPos1, blockState1, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(@NotNull Level level3, @NotNull BlockPos blockPos3, @NotNull BlockState blockState3, int i, int int1) {
            JChestBlockEntity.this.signalOpenCount(level3, blockPos3, blockState3, i, int1);
        }

        public boolean isOwnContainer(Player player1) {
            if (!(player1.containerMenu instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player1.containerMenu).getContainer();
            return container == JChestBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)JChestBlockEntity.this);
        }
    };

    protected JChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public JChestBlockEntity(BlockPos worldPosition, BlockState blockState) {
        this((BlockEntityType)JBlockEntities.JCHEST.get(), worldPosition, blockState);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, JChestBlockEntity blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void startOpen(ContainerUser player) {
        if (!this.remove && !player.getLivingEntity().isSpectator()) {
            this.openersCounter.incrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState(), player.getContainerInteractionRange());
        }
    }

    public void stopOpen(ContainerUser player) {
        if (!this.remove && !player.getLivingEntity().isSpectator()) {
            this.openersCounter.decrementOpeners(player.getLivingEntity(), this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int id, @NotNull Inventory player) {
        return ChestMenu.threeRows((int)id, (Inventory)player, (Container)this);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(Objects.requireNonNull(this.getLevel()), this.getBlockPos(), this.getBlockState());
        }
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        ChestType chesttype = (ChestType)state.getValue((Property)ChestBlock.TYPE);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.getConnectedDirection((BlockState)state);
                d0 += (double)direction.getStepX() * 0.5;
                d2 += (double)direction.getStepZ() * 0.5;
            }
            level.playSound(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }
}

