/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.gear;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.jitl.common.items.base.JArmorItem;
import net.jitl.common.items.gear.FullArmorAbility;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jetbrains.annotations.NotNull;

public class PlayerArmor
implements ValueIOSerializable {
    private ArrayList<ItemStack> armorPieces;
    private FullArmorAbility fullSet;
    private CompoundTag nbt = new CompoundTag();

    public void copyFrom(PlayerArmor source) {
        this.armorPieces = source.armorPieces;
        this.fullSet = source.fullSet;
        this.nbt = source.nbt;
    }

    public void setArmor(Iterator<ItemStack> iterator) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack currentStack = iterator.next();
        Item item = currentStack.getItem();
        ArmorMaterial material = null;
        FullArmorAbility fullArmorAbility = null;
        if (item instanceof JArmorItem) {
            stacks.add(currentStack);
            fullArmorAbility = Objects.requireNonNull(((JArmorItem)item).getAbility()).getFullAbility(this.nbt);
            if (fullArmorAbility != null) {
                material = ((JArmorItem)item).getMaterial();
            }
        }
        while (iterator.hasNext()) {
            currentStack = iterator.next();
            item = currentStack.getItem();
            if (item instanceof JArmorItem) {
                if (((JArmorItem)item).getMaterial() != material) {
                    fullArmorAbility = null;
                    material = null;
                }
                stacks.add(currentStack);
                continue;
            }
            fullArmorAbility = null;
            material = null;
        }
        stacks.trimToSize();
        this.armorPieces = stacks;
        this.fullSet = fullArmorAbility;
    }

    public ArrayList<ItemStack> getArmor() {
        return this.armorPieces;
    }

    public FullArmorAbility getFullArmor() {
        return this.fullSet;
    }

    public void serialize(ValueOutput valueOutput) {
    }

    public void deserialize(@NotNull ValueInput valueInput) {
    }
}

