/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JMonsterEntity
extends Monster
implements GeoEntity {
    protected EnumKnowledge knowledge;
    protected float knowledgeAmount = 0.0f;
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.defineId(JMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected JMonsterEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    public boolean checkSpawnRules(LevelAccessor level, @NotNull EntitySpawnReason type) {
        return !level.getBiome(this.blockPosition()).is(Tags.Biomes.IS_MUSHROOM) && !level.getBiome(this.blockPosition()).is(Biomes.DEEP_DARK);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addXP(this.knowledge, this.knowledgeAmount, player);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ATTACK, (Object)false);
    }

    protected void readAdditionalSaveData(ValueInput compound) {
        this.setAttacking(compound.getBooleanOr("attack", true));
    }

    protected void addAdditionalSaveData(ValueOutput compound) {
        compound.putBoolean("attack", this.isAttacking());
    }

    public boolean isAttacking() {
        return (Boolean)this.getEntityData().get(ATTACK);
    }

    public void setAttacking(boolean value) {
        this.getEntityData().set(ATTACK, (Object)value);
    }

    public class AnimatedAttackGoal
    extends MeleeAttackGoal {
        private final JMonsterEntity entity;

        public AnimatedAttackGoal(JMonsterEntity entity, double speed, boolean useLongMemory) {
            super((PathfinderMob)entity, speed, useLongMemory);
            this.entity = entity;
        }

        public void stop() {
            super.stop();
            this.entity.setAggressive(false);
            JMonsterEntity.this.setAttacking(false);
        }

        public boolean canUse() {
            LivingEntity livingEntity = JMonsterEntity.this.getTarget();
            return livingEntity != null && livingEntity.isAlive();
        }

        protected void checkAndPerformAttack(LivingEntity enemy) {
            if (this.canPerformAttack(enemy)) {
                this.resetAttackCooldown();
                JMonsterEntity.this.setAttacking(true);
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget(AnimatedAttackGoal.getServerLevel((Entity)this.mob), (Entity)enemy);
            }
        }
    }
}

