/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.depths;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JTamableEntity;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class DarknessCrawler
extends JTamableEntity {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.darkness_crawler.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.darkness_crawler.idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlayAndHold("animation.darkness_crawler.sit");

    public DarknessCrawler(EntityType<? extends JTamableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.DEPTHS, 5.0f, true);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 58.0).add(Attributes.ATTACK_DAMAGE, 11.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.DEPTHS_HUNTER.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.SPIKED_BEAST_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.SPIKED_BEAST_HURT.get();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isInSittingPose()) {
                return state.setAndContinue(this.SIT);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    @Override
    public int setBaseHealth() {
        return 58;
    }

    @Override
    public int setTameHealth() {
        return 68;
    }

    @Override
    public Item getTameItem() {
        return (Item)JItems.BEASTLY_STOMACH.get();
    }
}

