/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.euca;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JTamableEntity;
import net.jitl.core.init.internal.JItems;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class EucaHopper
extends JTamableEntity {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.euca_hopper.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.euca_hopper.idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlayAndHold("animation.euca_hopper.sit");

    public EucaHopper(EntityType<? extends EucaHopper> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.EUCA, 5.0f, true);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.ATTACK_DAMAGE, 7.5).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isInSittingPose()) {
                return state.setAndContinue(this.SIT);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    @Override
    public int setBaseHealth() {
        return 35;
    }

    @Override
    public int setTameHealth() {
        return 35;
    }

    @Override
    public Item getTameItem() {
        return (Item)JItems.EUCA_MEAT.get();
    }
}

