/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.goal;

import java.util.EnumSet;
import net.jitl.common.entity.base.IDontAttackWhenPeaceful;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class AttackWhenDifficultGoal
extends TargetGoal {
    private final IDontAttackWhenPeaceful mob;
    private final Mob entity;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public AttackWhenDifficultGoal(Mob entity, IDontAttackWhenPeaceful mob) {
        super(entity, false);
        this.entity = entity;
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        this.ownerLastHurtBy = this.entity.getLastHurtByMob();
        int i = this.entity.getLastHurtByMobTimestamp();
        return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && this.mob.wantsToAttack(this.ownerLastHurtBy, (LivingEntity)this.entity);
    }

    public void start() {
        this.entity.setTarget(this.ownerLastHurtBy);
        this.timestamp = this.entity.getLastHurtByMobTimestamp();
        super.start();
    }
}

