/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.jitl.common.entity.overworld.BoomBoom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class BoomSwellGoal
extends Goal {
    private final BoomBoom BoomBoom;
    @Nullable
    private LivingEntity target;

    public BoomSwellGoal(BoomBoom pBoomBoom) {
        this.BoomBoom = pBoomBoom;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.BoomBoom.getTarget();
        return this.BoomBoom.getSwellDir() > 0 || livingentity != null && this.BoomBoom.distanceToSqr((Entity)livingentity) < 9.0;
    }

    public void start() {
        this.BoomBoom.getNavigation().stop();
        this.target = this.BoomBoom.getTarget();
    }

    public void stop() {
        this.target = null;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.target == null) {
            this.BoomBoom.setSwellDir(-1);
        } else if (this.BoomBoom.distanceToSqr((Entity)this.target) > 49.0) {
            this.BoomBoom.setSwellDir(-1);
        } else if (!this.BoomBoom.getSensing().hasLineOfSight((Entity)this.target)) {
            this.BoomBoom.setSwellDir(-1);
        } else {
            this.BoomBoom.setSwellDir(1);
        }
    }
}

