/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.misc;

import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Sentacoin
extends Entity {
    public int coinAge;
    private int coinHealth = 5;
    private Type type = Type.COIN;

    public Sentacoin(EntityType<? extends Sentacoin> entity, Entity spawningEntity) {
        super(entity, spawningEntity.level());
        if (entity == JEntities.SENTACOIN_BAG_TYPE.get()) {
            this.type = Type.BAG;
        }
        this.setPos(spawningEntity.getX(), spawningEntity.getY(), spawningEntity.getZ());
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
    }

    public Sentacoin(EntityType<? extends Sentacoin> entity, Level level) {
        super(entity, level);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void tick() {
        super.tick();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.isEyeInFluid(FluidTags.WATER)) {
            this.setUnderwaterMovement();
        } else if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (this.level().getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.coinAge;
        if (this.coinAge >= 3000) {
            this.discard();
        }
    }

    private void setUnderwaterMovement() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x * (double)0.99f, Math.min(vec3.y + (double)5.0E-4f, (double)0.06f), vec3.z * (double)0.99f);
    }

    public boolean hurtServer(@NotNull ServerLevel serverLevel, DamageSource damageSource, float amount) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isInvisibleTo(player)) {
                return false;
            }
            if (this.level().isClientSide()) {
                return true;
            }
            this.markHurt();
            this.coinHealth = (int)((float)this.coinHealth - amount);
            if (this.coinHealth <= 0) {
                this.discard();
            }
            return true;
        }
        return false;
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.coinHealth = valueInput.getShortOr("Health", (short)0);
        this.coinAge = valueInput.getShortOr("Age", (short)0);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putShort("Health", (short)this.coinHealth);
        valueOutput.putShort("Age", (short)this.coinAge);
    }

    public void playerTouch(@NotNull Player player) {
        if (!this.level().isClientSide()) {
            int amount = 0;
            int bagRand = this.random.nextInt(10);
            int coinRand = this.random.nextInt(1);
            switch (this.type.ordinal()) {
                case 1: {
                    amount = 5 + bagRand;
                    break;
                }
                case 0: {
                    amount = 1 + coinRand;
                }
            }
            int finalAmount = amount;
            player.take((Entity)this, 1);
            ((PlayerStats)player.getData(JDataAttachments.PLAYER_STATS)).addSentacoins(finalAmount);
            if (this.type == Type.BAG) {
                for (int i = 0; i < 5; ++i) {
                    this.playSound((SoundEvent)JSounds.COIN_PICKUP.get(), 1.0f, 1.0f + this.random.nextFloat());
                }
            } else {
                this.playSound((SoundEvent)JSounds.COIN_PICKUP.get(), 1.0f, 1.0f + this.random.nextFloat());
            }
            this.discard();
        }
    }

    @NotNull
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public boolean isAttackable() {
        return false;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    public static enum Type {
        COIN,
        BAG;

    }
}

