/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld;

import net.jitl.common.entity.base.JTamableEntity;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Ferret
extends JTamableEntity {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.ferret.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.ferret.idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlayAndHold("animation.ferret.sit");

    public Ferret(EntityType<? extends JTamableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)JSounds.FERRET.get();
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.FERRET_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)JSounds.FERRET_DEATH.get();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.35).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isInSittingPose()) {
                return state.setAndContinue(this.SIT);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    @Override
    public int setBaseHealth() {
        return 40;
    }

    @Override
    public int setTameHealth() {
        return 40;
    }

    @Override
    public Item getTameItem() {
        return (Item)JItems.PET_FOOD.get();
    }
}

