/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld.npc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.jitl.client.util.ChatUtils;
import net.jitl.common.entity.base.CurrencyForItemsTrade;
import net.jitl.common.entity.base.JVillagerEntity;
import net.jitl.common.entity.base.JVillagerMob;
import net.jitl.core.init.internal.JItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;

public class Mage
extends JVillagerEntity {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 16, (ItemLike)JItems.LOOT_POUCH.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.LUNIUM_POWDER.get(), 8, (ItemLike)JItems.SAPPHIRE.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.CRIMSON_QUARTZ.get(), 32, (ItemLike)JItems.MEKYUM_INGOT.get(), 16, (ItemLike)JItems.PET_ROBOT_SPAWNER.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 16, (ItemLike)Items.FERMENTED_SPIDER_EYE, 2, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 10, (ItemLike)Items.GUNPOWDER, 4, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 4, (ItemLike)Items.REDSTONE, 8, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 16, (ItemLike)Items.PHANTOM_MEMBRANE, 2, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 16, (ItemLike)Items.GHAST_TEAR, 4, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 16, (ItemLike)Items.MAGMA_CREAM, 8, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 8, (ItemLike)Items.GLOWSTONE_DUST, 4, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.SAPPHIRE.get(), 32, (ItemLike)Items.BLAZE_POWDER, 8, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STONE_STICK, 2, (ItemLike)JItems.GREEN_GEM.get(), 10, (ItemLike)JItems.EARTHEN_HAMMER, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.EARTHEN_HAMMER, 1, (ItemLike)JItems.PURPLE_GEM.get(), 16, (ItemLike)JItems.SPELLBINDING_HAMMER, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.GREEN_GEM.get(), 10, (ItemLike)JItems.STAFF_OF_GREENPACE, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.BLOODCRUST_INGOT.get(), 10, (ItemLike)JItems.STAFF_OF_HELLSTONE, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.PURPLE_GEM.get(), 10, (ItemLike)JItems.DOOMSBRINGER, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.BOTTLE_OF_ESSENCIA.get(), 8, (ItemLike)JItems.STAFF_OF_ESSENCIA, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.YELLOW_GEM.get(), 10, (ItemLike)JItems.WIZARDS_STAR, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.BLUE_GEM.get(), 10, (ItemLike)JItems.STAFF_OF_ENLIGHTENMENT, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)JItems.STAFF_OF_GREENPACE.get(), 1, (ItemLike)JItems.STAFF_OF_CONJURING, 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.STAFF_BASE, 1, (ItemLike)Items.ENDER_PEARL, 64, (ItemLike)JItems.TELEPORTATION_STAFF, 1, 99, 5)}));
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.mage.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.mage.idle");

    public Mage(EntityType<? extends JVillagerEntity> type, Level worldIn) {
        super((EntityType<? extends JVillagerMob>)type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Override
    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand playerHand) {
        switch (this.random.nextInt(3)) {
            case 0: {
                ChatUtils.addDialogStyleChat(player, "jitl.trader.mage1");
                break;
            }
            case 1: {
                ChatUtils.addDialogStyleChat(player, "jitl.trader.mage2");
                break;
            }
            case 2: {
                ChatUtils.addDialogStyleChat(player, "jitl.trader.mage3");
            }
        }
        return super.mobInteract(player, playerHand);
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades() {
        return TRADES;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, 0.26).build();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController("controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        }));
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
    }

    protected void updateTrades() {
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }
}

