/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import javax.annotation.Nullable;
import net.jitl.core.data.JDamageSources;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class DemonicBombEntity
extends AbstractArrow
implements ItemSupplier {
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)JItems.DEMONIC_BOMB.get());

    public DemonicBombEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public DemonicBombEntity(Level worldIn, LivingEntity player, float damage, @Nullable ItemStack weapon) {
        super((EntityType)JEntities.DEMONIC_BOMB_TYPE.get(), player, worldIn, DEFAULT_ARROW_STACK, weapon);
        this.setBaseDamage(damage);
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)JSounds.KNIFE.get();
    }

    protected void onHitEntity(@NotNull EntityHitResult entityRayTraceResult_) {
        Entity entity = entityRayTraceResult_.getEntity();
        if (entity instanceof LivingEntity && entity != this.getOwner()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (entity instanceof LivingEntity && entity.hurtServer(level2, this.damageSources().thrown((Entity)this, this.getOwner()), 5.0f)) {
                    entity.hurtServer(level2, JDamageSources.hurt(entity, JDamageSources.DEMONIC_BOMB), 5.0f);
                    if (!this.level().isClientSide()) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)1);
                        this.discard();
                    }
                }
            }
            this.playSound((SoundEvent)JSounds.BOTTLE_PLUG.get(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        } else {
            super.onHitEntity(entityRayTraceResult_);
        }
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.isInGround() && this.collidedWith() != null && this.collidedWith() != this.getOwner() && (level = this.level()) instanceof ServerLevel) {
            LivingEntity entity;
            ServerLevel level2 = (ServerLevel)level;
            Entity entity2 = this.collidedWith();
            if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).hurtServer(level2, this.damageSources().thrown((Entity)this, this.getOwner()), 4.0f)) {
                entity.hurtServer(level2, JDamageSources.hurt((Entity)entity, JDamageSources.DEMONIC_BOMB), 4.0f);
                if (!this.level().isClientSide()) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)1);
                    this.discard();
                }
            }
        }
    }

    public Entity collidedWith() {
        for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox())) {
            if (!(entity instanceof LivingEntity)) continue;
            return entity;
        }
        return null;
    }

    public void handleEntityEvent(byte id) {
        int i;
        SpellParticleOption particleoptions = SpellParticleOption.create((ParticleType)ParticleTypes.EFFECT, (int)-1, (float)1.0f);
        if (id == 1) {
            for (i = 0; i < 15; ++i) {
                this.level().addParticle((ParticleOptions)particleoptions, this.getX() + this.level().random.nextDouble(), this.getY(), this.getZ() + this.level().random.nextDouble(), 1.0, 0.0, 0.0);
            }
        }
        if (id == 2) {
            for (i = 0; i < 15; ++i) {
                this.level().addParticle((ParticleOptions)particleoptions, this.getX() + this.level().random.nextDouble(), this.getY() + 1.0, this.getZ() + this.level().random.nextDouble(), 1.0, 0.0, 0.0);
            }
        }
    }

    protected boolean tryPickup(Player pPlayer) {
        return super.tryPickup(pPlayer);
    }

    @NotNull
    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)JItems.DEMONIC_BOMB.get());
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getPickupItem();
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)JItems.DEMONIC_BOMB.get());
    }
}

