/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EssenciaBoltEntity
extends LightningBolt {
    private static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.defineId(EssenciaBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_STRIKE_SOUND_VOL = SynchedEntityData.defineId(EssenciaBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_THUNDER_SOUND_VOL = SynchedEntityData.defineId(EssenciaBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public EssenciaBoltEntity(EntityType<? extends LightningBolt> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public void setARGB(int argb) {
        this.entityData.set(DATA_COLOR_ID, (Object)argb);
    }

    public int getARGB() {
        return (Integer)this.entityData.get(DATA_COLOR_ID);
    }

    public void setStrikeVolume(float volume) {
        this.entityData.set(DATA_STRIKE_SOUND_VOL, (Object)Float.valueOf(volume));
    }

    public float getStrikeVolume() {
        return ((Float)this.entityData.get(DATA_STRIKE_SOUND_VOL)).floatValue();
    }

    public void setThunderVolume(float volume) {
        this.entityData.set(DATA_THUNDER_SOUND_VOL, (Object)Float.valueOf(volume));
    }

    public float getThunderVolume() {
        return ((Float)this.entityData.get(DATA_THUNDER_SOUND_VOL)).floatValue();
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_COLOR_ID, (Object)0);
        pBuilder.define(DATA_STRIKE_SOUND_VOL, (Object)Float.valueOf(2.0f));
        pBuilder.define(DATA_THUNDER_SOUND_VOL, (Object)Float.valueOf(10000.0f));
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Color", this.getARGB());
        compound.putFloat("Strike Volume", this.getStrikeVolume());
        compound.putFloat("Thunder Volume", this.getThunderVolume());
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        this.setARGB(compound.getIntOr("Color", 0));
        this.setStrikeVolume(compound.getFloatOr("Strike Volume", 0.0f));
        this.setThunderVolume(compound.getFloatOr("Thunder Volume", 0.0f));
    }
}

