/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.EssenciaBoltEntity;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class EssenciaProjectileEntity
extends JThrowableProjectile {
    public EssenciaProjectileEntity(EntityType<EssenciaProjectileEntity> type, Level world) {
        super(type, world);
    }

    public EssenciaProjectileEntity(int damage, Level world, LivingEntity thrower) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)JEntities.ESSENCIA_PROJECTILE_TYPE.get()), damage, world, thrower);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)JParticleManager.ESSENCIA_LIGHTNING.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        EssenciaBoltEntity essenciaBoltEntity = new EssenciaBoltEntity((EntityType<? extends LightningBolt>)((EntityType)JEntities.ESSENCIA_BOLT_TYPE.get()), this.level());
        essenciaBoltEntity.setPos(result.getLocation().x(), result.getLocation().y(), result.getLocation().z());
        essenciaBoltEntity.setARGB(16730112);
        this.level().addFreshEntity((Entity)essenciaBoltEntity);
    }

    @Override
    protected void onHit(@NotNull HitResult r) {
        super.onHit(r);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected double getDefaultGravity() {
        return 0.003f;
    }
}

