/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.AbstractHomingEntity;
import net.jitl.common.entity.projectile.EssenciaBoltEntity;
import net.jitl.core.init.internal.JEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class SpellbindingEntity
extends AbstractHomingEntity {
    public SpellbindingEntity(EntityType<SpellbindingEntity> type, Level world) {
        super((EntityType<? extends AbstractHomingEntity>)type, world);
    }

    public SpellbindingEntity(int damage, Level world, LivingEntity thrower) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)JEntities.SPELLBINDING_TYPE.get()), damage, world, thrower);
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult result) {
        super.onHitEntity(result);
        if (result.getEntity() != this.getOwner()) {
            EssenciaBoltEntity essenciaBoltEntity = new EssenciaBoltEntity((EntityType<? extends LightningBolt>)((EntityType)JEntities.ESSENCIA_BOLT_TYPE.get()), this.level());
            essenciaBoltEntity.setPos(result.getLocation().x(), result.getLocation().y(), result.getLocation().z());
            essenciaBoltEntity.setARGB(0xFF00FF);
            this.level().addFreshEntity((Entity)essenciaBoltEntity);
        }
    }

    @Override
    public int getHomingRadius() {
        return 4;
    }
}

