/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.Consumer;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.TriFunction;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GunItem
extends JItem
implements IEssenceItem {
    protected TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory;
    private final int essenceUsage;
    private final int damage;

    public GunItem(Item.Properties p, int essence, int damage, int maxUses, TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory) {
        super(p.stacksTo(1).durability(maxUses));
        this.projectileFactory = projectileFactory;
        this.essenceUsage = essence;
        this.damage = damage;
    }

    public boolean releaseUsing(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (worldIn instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)worldIn;
                if ((double)GunItem.getPowerForTime(this.getUseDuration(stack, (LivingEntity)player) - timeLeft) > 0.25 && ((PlayerEssence)player.getData(JDataAttachments.ESSENCE)).consumeEssence(player, this.essenceUsage)) {
                    JThrowableProjectile projectile = this.projectileFactory.apply(this.damage, (Level)level, (LivingEntity)player);
                    projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                    level.addFreshEntity((Entity)projectile);
                    projectile.setPos(player.getX(), player.getEyeY(), player.getZ());
                    player.getItemInHand(player.getUsedItemHand()).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)JSounds.CANNON.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                }
            }
        }
        return true;
    }

    public static float getPowerForTime(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResult.CONSUME;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> comp, TooltipFlag pTooltipFlag) {
        comp.accept((Component)Component.translatable((String)"jitl.tooltip.cannon", (Object[])new Object[]{this.damage / 2}));
        this.addItemDesc(JItems.NETHER_PLASMA.asItem(), comp, "jitl.tooltip.nether_plasma");
        this.addItemDesc(JItems.OCEAN_PLASMA.asItem(), comp, "jitl.tooltip.ocean_plasma");
        this.addItemDesc(JItems.FOREST_PLASMA.asItem(), comp, "jitl.tooltip.forest_plasma");
        this.addItemDesc(JItems.ROCK_LAUNCHER.asItem(), comp, "jitl.tooltip.rock_launcher");
        this.addItemDesc(JItems.CHAOS_CANNON.asItem(), comp, "jitl.tooltip.chaos_cannon");
        this.addItemDesc(JItems.EYE_BLASTER.asItem(), comp, "jitl.tooltip.eye_blaster");
        comp.accept((Component)Component.translatable((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
        comp.accept((Component)Component.translatable((String)"jitl.uses_remaining", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}));
    }
}

