/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.Consumer;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HealingItem
extends JItem
implements IEssenceItem {
    public float amount = 0.0f;

    public HealingItem(Item.Properties props, float amount) {
        super(props.stacksTo(1).durability(1));
        this.amount = amount;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        if (!level.isClientSide()) {
            player.heal(this.amount == -1.0f ? player.getMaxHealth() : this.amount);
            player.getItemInHand(usedHand).shrink(1);
            return InteractionResult.CONSUME;
        }
        level.playSound((Entity)player, player.getOnPos(), (SoundEvent)JSounds.STAFF_0.get(), SoundSource.BLOCKS);
        return InteractionResult.FAIL;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag pTooltipFlag) {
        if (this.amount == -1.0f) {
            tooltip.accept((Component)Component.translatable((String)"jitl.item.desc.full_health"));
        } else {
            tooltip.accept((Component)Component.literal((String)("Restores " + this.amount + " health")));
        }
    }
}

