/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import net.jitl.common.entity.projectile.KnifeEntity;
import net.jitl.common.items.base.JSwordItem;
import net.jitl.core.helper.JToolTiers;
import net.jitl.core.init.internal.JItems;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class KnifeItem
extends JSwordItem {
    public final float damage;

    public KnifeItem(Item.Properties properties, float damage) {
        super(properties, JToolTiers.THROWING_KNIFE, JItems.BASIC);
        this.damage = damage;
    }

    @Override
    @NotNull
    public InteractionResult use(Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide()) {
            KnifeEntity entity = new KnifeEntity((LivingEntity)playerIn, worldIn, stack, this.damage, stack);
            entity.setPos(playerIn.getX(), playerIn.getEyeY(), playerIn.getZ());
            entity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            if (playerIn.isCreative()) {
                entity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            } else {
                stack.shrink(1);
            }
            worldIn.addFreshEntity((Entity)entity);
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return InteractionResult.SUCCESS;
    }
}

