/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.function.Consumer;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ObstructorItem
extends JItem
implements IEssenceItem {
    public final Type type;

    public ObstructorItem(Item.Properties pProperties, Type type) {
        super(pProperties);
        this.type = type;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (((PlayerEssence)player.getData(JDataAttachments.ESSENCE)).consumeEssence(player, 5.0f)) {
                int playerArea = 10;
                AABB axisalignedbb = AABB.ofSize((Vec3)player.position(), (double)playerArea, (double)playerArea, (double)playerArea);
                for (LivingEntity entity : level.getEntitiesOfClass(LivingEntity.class, axisalignedbb)) {
                    if (entity instanceof Player) continue;
                    int duration = 60;
                    if (this.type == Type.NETHER) {
                        entity.setRemainingFireTicks(duration);
                    }
                    if (this.type != Type.WITHIC) continue;
                    entity.addEffect(new MobEffectInstance(MobEffects.WITHER, duration));
                }
            }
        }
        return super.use(level, player, hand);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, TooltipDisplay display, Consumer<Component> comp, TooltipFlag pTooltipFlag) {
        if (this.type == Type.WITHIC) {
            comp.accept((Component)Component.translatable((String)"jitl.item.desc.withic_obstructor"));
        }
        if (this.type == Type.NETHER) {
            comp.accept((Component)Component.translatable((String)"jitl.item.desc.nethic_obstructor"));
        }
        comp.accept((Component)Component.translatable((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{5}));
        comp.accept((Component)Component.translatable((String)"jitl.uses_remaining", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}));
    }

    public static enum Type {
        WITHIC,
        NETHER;

    }
}

